/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.EncryptionPreferences;
import com.azure.resourcemanager.databox.models.TransportPreferences;
import java.io.IOException;
import java.util.List;

public final class Preferences
implements JsonSerializable<Preferences> {
    private List<String> preferredDataCenterRegion;
    private TransportPreferences transportPreferences;
    private TransportPreferences reverseTransportPreferences;
    private EncryptionPreferences encryptionPreferences;
    private List<String> storageAccountAccessTierPreferences;

    public List<String> preferredDataCenterRegion() {
        return this.preferredDataCenterRegion;
    }

    public Preferences withPreferredDataCenterRegion(List<String> preferredDataCenterRegion) {
        this.preferredDataCenterRegion = preferredDataCenterRegion;
        return this;
    }

    public TransportPreferences transportPreferences() {
        return this.transportPreferences;
    }

    public Preferences withTransportPreferences(TransportPreferences transportPreferences) {
        this.transportPreferences = transportPreferences;
        return this;
    }

    public TransportPreferences reverseTransportPreferences() {
        return this.reverseTransportPreferences;
    }

    public Preferences withReverseTransportPreferences(TransportPreferences reverseTransportPreferences) {
        this.reverseTransportPreferences = reverseTransportPreferences;
        return this;
    }

    public EncryptionPreferences encryptionPreferences() {
        return this.encryptionPreferences;
    }

    public Preferences withEncryptionPreferences(EncryptionPreferences encryptionPreferences) {
        this.encryptionPreferences = encryptionPreferences;
        return this;
    }

    public List<String> storageAccountAccessTierPreferences() {
        return this.storageAccountAccessTierPreferences;
    }

    public Preferences withStorageAccountAccessTierPreferences(List<String> storageAccountAccessTierPreferences) {
        this.storageAccountAccessTierPreferences = storageAccountAccessTierPreferences;
        return this;
    }

    public void validate() {
        if (this.transportPreferences() != null) {
            this.transportPreferences().validate();
        }
        if (this.reverseTransportPreferences() != null) {
            this.reverseTransportPreferences().validate();
        }
        if (this.encryptionPreferences() != null) {
            this.encryptionPreferences().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("preferredDataCenterRegion", this.preferredDataCenterRegion, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("transportPreferences", (JsonSerializable)this.transportPreferences);
        jsonWriter.writeJsonField("reverseTransportPreferences", (JsonSerializable)this.reverseTransportPreferences);
        jsonWriter.writeJsonField("encryptionPreferences", (JsonSerializable)this.encryptionPreferences);
        jsonWriter.writeArrayField("storageAccountAccessTierPreferences", this.storageAccountAccessTierPreferences, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static Preferences fromJson(JsonReader jsonReader) throws IOException {
        return (Preferences)jsonReader.readObject(reader -> {
            Preferences deserializedPreferences = new Preferences();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("preferredDataCenterRegion".equals(fieldName)) {
                    List preferredDataCenterRegion;
                    deserializedPreferences.preferredDataCenterRegion = preferredDataCenterRegion = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("transportPreferences".equals(fieldName)) {
                    deserializedPreferences.transportPreferences = TransportPreferences.fromJson(reader);
                    continue;
                }
                if ("reverseTransportPreferences".equals(fieldName)) {
                    deserializedPreferences.reverseTransportPreferences = TransportPreferences.fromJson(reader);
                    continue;
                }
                if ("encryptionPreferences".equals(fieldName)) {
                    deserializedPreferences.encryptionPreferences = EncryptionPreferences.fromJson(reader);
                    continue;
                }
                if ("storageAccountAccessTierPreferences".equals(fieldName)) {
                    List storageAccountAccessTierPreferences;
                    deserializedPreferences.storageAccountAccessTierPreferences = storageAccountAccessTierPreferences = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPreferences;
        });
    }
}

