/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.NotificationStageName;
import java.io.IOException;

public final class NotificationPreference
implements JsonSerializable<NotificationPreference> {
    private NotificationStageName stageName;
    private boolean sendNotification;
    private static final ClientLogger LOGGER = new ClientLogger(NotificationPreference.class);

    public NotificationStageName stageName() {
        return this.stageName;
    }

    public NotificationPreference withStageName(NotificationStageName stageName) {
        this.stageName = stageName;
        return this;
    }

    public boolean sendNotification() {
        return this.sendNotification;
    }

    public NotificationPreference withSendNotification(boolean sendNotification) {
        this.sendNotification = sendNotification;
        return this;
    }

    public void validate() {
        if (this.stageName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property stageName in model NotificationPreference"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("stageName", this.stageName == null ? null : this.stageName.toString());
        jsonWriter.writeBooleanField("sendNotification", this.sendNotification);
        return jsonWriter.writeEndObject();
    }

    public static NotificationPreference fromJson(JsonReader jsonReader) throws IOException {
        return (NotificationPreference)jsonReader.readObject(reader -> {
            NotificationPreference deserializedNotificationPreference = new NotificationPreference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("stageName".equals(fieldName)) {
                    deserializedNotificationPreference.stageName = NotificationStageName.fromString(reader.getString());
                    continue;
                }
                if ("sendNotification".equals(fieldName)) {
                    deserializedNotificationPreference.sendNotification = reader.getBoolean();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNotificationPreference;
        });
    }
}

