/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.CustomerResolutionCode;
import java.io.IOException;
import java.util.Map;

public final class MitigateJobRequest
implements JsonSerializable<MitigateJobRequest> {
    private CustomerResolutionCode customerResolutionCode;
    private Map<String, CustomerResolutionCode> serialNumberCustomerResolutionMap;

    public CustomerResolutionCode customerResolutionCode() {
        return this.customerResolutionCode;
    }

    public MitigateJobRequest withCustomerResolutionCode(CustomerResolutionCode customerResolutionCode) {
        this.customerResolutionCode = customerResolutionCode;
        return this;
    }

    public Map<String, CustomerResolutionCode> serialNumberCustomerResolutionMap() {
        return this.serialNumberCustomerResolutionMap;
    }

    public MitigateJobRequest withSerialNumberCustomerResolutionMap(Map<String, CustomerResolutionCode> serialNumberCustomerResolutionMap) {
        this.serialNumberCustomerResolutionMap = serialNumberCustomerResolutionMap;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("customerResolutionCode", this.customerResolutionCode == null ? null : this.customerResolutionCode.toString());
        jsonWriter.writeMapField("serialNumberCustomerResolutionMap", this.serialNumberCustomerResolutionMap, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static MitigateJobRequest fromJson(JsonReader jsonReader) throws IOException {
        return (MitigateJobRequest)jsonReader.readObject(reader -> {
            MitigateJobRequest deserializedMitigateJobRequest = new MitigateJobRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("customerResolutionCode".equals(fieldName)) {
                    deserializedMitigateJobRequest.customerResolutionCode = CustomerResolutionCode.fromString(reader.getString());
                    continue;
                }
                if ("serialNumberCustomerResolutionMap".equals(fieldName)) {
                    Map serialNumberCustomerResolutionMap;
                    deserializedMitigateJobRequest.serialNumberCustomerResolutionMap = serialNumberCustomerResolutionMap = reader.readMap(reader1 -> CustomerResolutionCode.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMitigateJobRequest;
        });
    }
}

