/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.DataAccountDetails;
import com.azure.resourcemanager.databox.models.DataAccountType;
import java.io.IOException;

public final class ManagedDiskDetails
extends DataAccountDetails {
    private DataAccountType dataAccountType = DataAccountType.MANAGED_DISK;
    private String resourceGroupId;
    private String stagingStorageAccountId;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedDiskDetails.class);

    @Override
    public DataAccountType dataAccountType() {
        return this.dataAccountType;
    }

    public String resourceGroupId() {
        return this.resourceGroupId;
    }

    public ManagedDiskDetails withResourceGroupId(String resourceGroupId) {
        this.resourceGroupId = resourceGroupId;
        return this;
    }

    public String stagingStorageAccountId() {
        return this.stagingStorageAccountId;
    }

    public ManagedDiskDetails withStagingStorageAccountId(String stagingStorageAccountId) {
        this.stagingStorageAccountId = stagingStorageAccountId;
        return this;
    }

    @Override
    public ManagedDiskDetails withSharePassword(String sharePassword) {
        super.withSharePassword(sharePassword);
        return this;
    }

    @Override
    public void validate() {
        if (this.resourceGroupId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceGroupId in model ManagedDiskDetails"));
        }
        if (this.stagingStorageAccountId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property stagingStorageAccountId in model ManagedDiskDetails"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sharePassword", this.sharePassword());
        jsonWriter.writeStringField("resourceGroupId", this.resourceGroupId);
        jsonWriter.writeStringField("stagingStorageAccountId", this.stagingStorageAccountId);
        jsonWriter.writeStringField("dataAccountType", this.dataAccountType == null ? null : this.dataAccountType.toString());
        return jsonWriter.writeEndObject();
    }

    public static ManagedDiskDetails fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedDiskDetails)jsonReader.readObject(reader -> {
            ManagedDiskDetails deserializedManagedDiskDetails = new ManagedDiskDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sharePassword".equals(fieldName)) {
                    deserializedManagedDiskDetails.withSharePassword(reader.getString());
                    continue;
                }
                if ("resourceGroupId".equals(fieldName)) {
                    deserializedManagedDiskDetails.resourceGroupId = reader.getString();
                    continue;
                }
                if ("stagingStorageAccountId".equals(fieldName)) {
                    deserializedManagedDiskDetails.stagingStorageAccountId = reader.getString();
                    continue;
                }
                if ("dataAccountType".equals(fieldName)) {
                    deserializedManagedDiskDetails.dataAccountType = DataAccountType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedDiskDetails;
        });
    }
}

