/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.CustomerResolutionCode;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class LastMitigationActionOnJob
implements JsonSerializable<LastMitigationActionOnJob> {
    private OffsetDateTime actionDateTimeInUtc;
    private Boolean isPerformedByCustomer;
    private CustomerResolutionCode customerResolution;

    public OffsetDateTime actionDateTimeInUtc() {
        return this.actionDateTimeInUtc;
    }

    public LastMitigationActionOnJob withActionDateTimeInUtc(OffsetDateTime actionDateTimeInUtc) {
        this.actionDateTimeInUtc = actionDateTimeInUtc;
        return this;
    }

    public Boolean isPerformedByCustomer() {
        return this.isPerformedByCustomer;
    }

    public LastMitigationActionOnJob withIsPerformedByCustomer(Boolean isPerformedByCustomer) {
        this.isPerformedByCustomer = isPerformedByCustomer;
        return this;
    }

    public CustomerResolutionCode customerResolution() {
        return this.customerResolution;
    }

    public LastMitigationActionOnJob withCustomerResolution(CustomerResolutionCode customerResolution) {
        this.customerResolution = customerResolution;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("actionDateTimeInUtc", this.actionDateTimeInUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.actionDateTimeInUtc));
        jsonWriter.writeBooleanField("isPerformedByCustomer", this.isPerformedByCustomer);
        jsonWriter.writeStringField("customerResolution", this.customerResolution == null ? null : this.customerResolution.toString());
        return jsonWriter.writeEndObject();
    }

    public static LastMitigationActionOnJob fromJson(JsonReader jsonReader) throws IOException {
        return (LastMitigationActionOnJob)jsonReader.readObject(reader -> {
            LastMitigationActionOnJob deserializedLastMitigationActionOnJob = new LastMitigationActionOnJob();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("actionDateTimeInUtc".equals(fieldName)) {
                    deserializedLastMitigationActionOnJob.actionDateTimeInUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("isPerformedByCustomer".equals(fieldName)) {
                    deserializedLastMitigationActionOnJob.isPerformedByCustomer = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("customerResolution".equals(fieldName)) {
                    deserializedLastMitigationActionOnJob.customerResolution = CustomerResolutionCode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLastMitigationActionOnJob;
        });
    }
}

