/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.IdentityProperties;
import com.azure.resourcemanager.databox.models.KekType;
import java.io.IOException;

public final class KeyEncryptionKey
implements JsonSerializable<KeyEncryptionKey> {
    private KekType kekType;
    private IdentityProperties identityProperties;
    private String kekUrl;
    private String kekVaultResourceId;
    private static final ClientLogger LOGGER = new ClientLogger(KeyEncryptionKey.class);

    public KekType kekType() {
        return this.kekType;
    }

    public KeyEncryptionKey withKekType(KekType kekType) {
        this.kekType = kekType;
        return this;
    }

    public IdentityProperties identityProperties() {
        return this.identityProperties;
    }

    public KeyEncryptionKey withIdentityProperties(IdentityProperties identityProperties) {
        this.identityProperties = identityProperties;
        return this;
    }

    public String kekUrl() {
        return this.kekUrl;
    }

    public KeyEncryptionKey withKekUrl(String kekUrl) {
        this.kekUrl = kekUrl;
        return this;
    }

    public String kekVaultResourceId() {
        return this.kekVaultResourceId;
    }

    public KeyEncryptionKey withKekVaultResourceId(String kekVaultResourceId) {
        this.kekVaultResourceId = kekVaultResourceId;
        return this;
    }

    public void validate() {
        if (this.kekType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property kekType in model KeyEncryptionKey"));
        }
        if (this.identityProperties() != null) {
            this.identityProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kekType", this.kekType == null ? null : this.kekType.toString());
        jsonWriter.writeJsonField("identityProperties", (JsonSerializable)this.identityProperties);
        jsonWriter.writeStringField("kekUrl", this.kekUrl);
        jsonWriter.writeStringField("kekVaultResourceID", this.kekVaultResourceId);
        return jsonWriter.writeEndObject();
    }

    public static KeyEncryptionKey fromJson(JsonReader jsonReader) throws IOException {
        return (KeyEncryptionKey)jsonReader.readObject(reader -> {
            KeyEncryptionKey deserializedKeyEncryptionKey = new KeyEncryptionKey();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kekType".equals(fieldName)) {
                    deserializedKeyEncryptionKey.kekType = KekType.fromString(reader.getString());
                    continue;
                }
                if ("identityProperties".equals(fieldName)) {
                    deserializedKeyEncryptionKey.identityProperties = IdentityProperties.fromJson(reader);
                    continue;
                }
                if ("kekUrl".equals(fieldName)) {
                    deserializedKeyEncryptionKey.kekUrl = reader.getString();
                    continue;
                }
                if ("kekVaultResourceID".equals(fieldName)) {
                    deserializedKeyEncryptionKey.kekVaultResourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyEncryptionKey;
        });
    }
}

