/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.JobDelayDetails;
import com.azure.resourcemanager.databox.models.StageName;
import com.azure.resourcemanager.databox.models.StageStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class JobStages
implements JsonSerializable<JobStages> {
    private StageName stageName;
    private String displayName;
    private StageStatus stageStatus;
    private OffsetDateTime stageTime;
    private Object jobStageDetails;
    private List<JobDelayDetails> delayInformation;

    public StageName stageName() {
        return this.stageName;
    }

    public String displayName() {
        return this.displayName;
    }

    public StageStatus stageStatus() {
        return this.stageStatus;
    }

    public OffsetDateTime stageTime() {
        return this.stageTime;
    }

    public Object jobStageDetails() {
        return this.jobStageDetails;
    }

    public List<JobDelayDetails> delayInformation() {
        return this.delayInformation;
    }

    public void validate() {
        if (this.delayInformation() != null) {
            this.delayInformation().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static JobStages fromJson(JsonReader jsonReader) throws IOException {
        return (JobStages)jsonReader.readObject(reader -> {
            JobStages deserializedJobStages = new JobStages();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("stageName".equals(fieldName)) {
                    deserializedJobStages.stageName = StageName.fromString(reader.getString());
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedJobStages.displayName = reader.getString();
                    continue;
                }
                if ("stageStatus".equals(fieldName)) {
                    deserializedJobStages.stageStatus = StageStatus.fromString(reader.getString());
                    continue;
                }
                if ("stageTime".equals(fieldName)) {
                    deserializedJobStages.stageTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("jobStageDetails".equals(fieldName)) {
                    deserializedJobStages.jobStageDetails = reader.readUntyped();
                    continue;
                }
                if ("delayInformation".equals(fieldName)) {
                    List delayInformation;
                    deserializedJobStages.delayInformation = delayInformation = reader.readArray(reader1 -> JobDelayDetails.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobStages;
        });
    }
}

