/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ClassDiscriminator;
import com.azure.resourcemanager.databox.models.CloudError;
import com.azure.resourcemanager.databox.models.CustomerDiskJobSecrets;
import com.azure.resourcemanager.databox.models.DataBoxDiskJobSecrets;
import com.azure.resourcemanager.databox.models.DataBoxHeavyJobSecrets;
import com.azure.resourcemanager.databox.models.DataboxJobSecrets;
import com.azure.resourcemanager.databox.models.DcAccessSecurityCode;
import java.io.IOException;

public class JobSecrets
implements JsonSerializable<JobSecrets> {
    private ClassDiscriminator jobSecretsType;
    private DcAccessSecurityCode dcAccessSecurityCode;
    private CloudError error;

    public ClassDiscriminator jobSecretsType() {
        return this.jobSecretsType;
    }

    public DcAccessSecurityCode dcAccessSecurityCode() {
        return this.dcAccessSecurityCode;
    }

    JobSecrets withDcAccessSecurityCode(DcAccessSecurityCode dcAccessSecurityCode) {
        this.dcAccessSecurityCode = dcAccessSecurityCode;
        return this;
    }

    public CloudError error() {
        return this.error;
    }

    JobSecrets withError(CloudError error) {
        this.error = error;
        return this;
    }

    public void validate() {
        if (this.dcAccessSecurityCode() != null) {
            this.dcAccessSecurityCode().validate();
        }
        if (this.error() != null) {
            this.error().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("jobSecretsType", this.jobSecretsType == null ? null : this.jobSecretsType.toString());
        return jsonWriter.writeEndObject();
    }

    public static JobSecrets fromJson(JsonReader jsonReader) throws IOException {
        return (JobSecrets)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                JobSecrets jobSecrets;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("jobSecretsType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("DataBoxCustomerDisk".equals(discriminatorValue)) {
                    jobSecrets = CustomerDiskJobSecrets.fromJson(readerToUse.reset());
                    return jobSecrets;
                }
                if ("DataBoxDisk".equals(discriminatorValue)) {
                    jobSecrets = DataBoxDiskJobSecrets.fromJson(readerToUse.reset());
                    return jobSecrets;
                }
                if ("DataBoxHeavy".equals(discriminatorValue)) {
                    jobSecrets = DataBoxHeavyJobSecrets.fromJson(readerToUse.reset());
                    return jobSecrets;
                }
                if ("DataBox".equals(discriminatorValue)) {
                    jobSecrets = DataboxJobSecrets.fromJson(readerToUse.reset());
                    return jobSecrets;
                }
                jobSecrets = JobSecrets.fromJsonKnownDiscriminator(readerToUse.reset());
                return jobSecrets;
            }
        });
    }

    static JobSecrets fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (JobSecrets)jsonReader.readObject(reader -> {
            JobSecrets deserializedJobSecrets = new JobSecrets();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("jobSecretsType".equals(fieldName)) {
                    deserializedJobSecrets.jobSecretsType = ClassDiscriminator.fromString(reader.getString());
                    continue;
                }
                if ("dcAccessSecurityCode".equals(fieldName)) {
                    deserializedJobSecrets.dcAccessSecurityCode = DcAccessSecurityCode.fromJson(reader);
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedJobSecrets.error = CloudError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobSecrets;
        });
    }
}

