/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.fluent.models.UpdateJobProperties;
import com.azure.resourcemanager.databox.models.ResourceIdentity;
import com.azure.resourcemanager.databox.models.UpdateJobDetails;
import java.io.IOException;
import java.util.Map;

public final class JobResourceUpdateParameter
implements JsonSerializable<JobResourceUpdateParameter> {
    private UpdateJobProperties innerProperties;
    private Map<String, String> tags;
    private ResourceIdentity identity;

    private UpdateJobProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public JobResourceUpdateParameter withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ResourceIdentity identity() {
        return this.identity;
    }

    public JobResourceUpdateParameter withIdentity(ResourceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public UpdateJobDetails details() {
        return this.innerProperties() == null ? null : this.innerProperties().details();
    }

    public JobResourceUpdateParameter withDetails(UpdateJobDetails details) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UpdateJobProperties();
        }
        this.innerProperties().withDetails(details);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static JobResourceUpdateParameter fromJson(JsonReader jsonReader) throws IOException {
        return (JobResourceUpdateParameter)jsonReader.readObject(reader -> {
            JobResourceUpdateParameter deserializedJobResourceUpdateParameter = new JobResourceUpdateParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedJobResourceUpdateParameter.innerProperties = UpdateJobProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedJobResourceUpdateParameter.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedJobResourceUpdateParameter.identity = ResourceIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobResourceUpdateParameter;
        });
    }
}

