/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.fluent.models.JobResourceInner;
import java.io.IOException;
import java.util.List;

public final class JobResourceList
implements JsonSerializable<JobResourceList> {
    private List<JobResourceInner> value;
    private String nextLink;

    public List<JobResourceInner> value() {
        return this.value;
    }

    public JobResourceList withValue(List<JobResourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public JobResourceList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static JobResourceList fromJson(JsonReader jsonReader) throws IOException {
        return (JobResourceList)jsonReader.readObject(reader -> {
            JobResourceList deserializedJobResourceList = new JobResourceList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedJobResourceList.value = value = reader.readArray(reader1 -> JobResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedJobResourceList.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobResourceList;
        });
    }
}

