/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.databox.fluent.models.JobResourceInner;
import com.azure.resourcemanager.databox.models.CancellationReason;
import com.azure.resourcemanager.databox.models.CloudError;
import com.azure.resourcemanager.databox.models.JobDeliveryInfo;
import com.azure.resourcemanager.databox.models.JobDeliveryType;
import com.azure.resourcemanager.databox.models.JobDetails;
import com.azure.resourcemanager.databox.models.MarkDevicesShippedRequest;
import com.azure.resourcemanager.databox.models.ResourceIdentity;
import com.azure.resourcemanager.databox.models.ReverseShippingDetailsEditStatus;
import com.azure.resourcemanager.databox.models.ReverseTransportPreferenceEditStatus;
import com.azure.resourcemanager.databox.models.ShipmentPickUpRequest;
import com.azure.resourcemanager.databox.models.ShipmentPickUpResponse;
import com.azure.resourcemanager.databox.models.Sku;
import com.azure.resourcemanager.databox.models.StageName;
import com.azure.resourcemanager.databox.models.TransferType;
import com.azure.resourcemanager.databox.models.UnencryptedCredentials;
import com.azure.resourcemanager.databox.models.UpdateJobDetails;
import java.time.OffsetDateTime;
import java.util.Map;

public interface JobResource {
    public String location();

    public Map<String, String> tags();

    public String name();

    public String id();

    public String type();

    public SystemData systemData();

    public Sku sku();

    public ResourceIdentity identity();

    public TransferType transferType();

    public Boolean isCancellable();

    public Boolean isDeletable();

    public Boolean isShippingAddressEditable();

    public ReverseShippingDetailsEditStatus reverseShippingDetailsUpdate();

    public ReverseTransportPreferenceEditStatus reverseTransportPreferenceUpdate();

    public Boolean isPrepareToShipEnabled();

    public StageName status();

    public StageName delayedStage();

    public OffsetDateTime startTime();

    public CloudError error();

    public JobDetails details();

    public String cancellationReason();

    public JobDeliveryType deliveryType();

    public JobDeliveryInfo deliveryInfo();

    public Boolean isCancellableWithoutFee();

    public Boolean allDevicesLost();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public JobResourceInner innerModel();

    public Update update();

    public JobResource refresh();

    public JobResource refresh(Context var1);

    public Response<Void> markDevicesShippedWithResponse(MarkDevicesShippedRequest var1, Context var2);

    public void markDevicesShipped(MarkDevicesShippedRequest var1);

    public Response<ShipmentPickUpResponse> bookShipmentPickUpWithResponse(ShipmentPickUpRequest var1, Context var2);

    public ShipmentPickUpResponse bookShipmentPickUp(ShipmentPickUpRequest var1);

    public Response<Void> cancelWithResponse(CancellationReason var1, Context var2);

    public void cancel(CancellationReason var1);

    public PagedIterable<UnencryptedCredentials> listCredentials();

    public PagedIterable<UnencryptedCredentials> listCredentials(Context var1);

    public static interface UpdateStages {

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithDetails {
            public Update withDetails(UpdateJobDetails var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(ResourceIdentity var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithDetails,
    UpdateStages.WithIfMatch {
        public JobResource apply();

        public JobResource apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithDeliveryInfo {
            public WithCreate withDeliveryInfo(JobDeliveryInfo var1);
        }

        public static interface WithDeliveryType {
            public WithCreate withDeliveryType(JobDeliveryType var1);
        }

        public static interface WithDetails {
            public WithCreate withDetails(JobDetails var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(ResourceIdentity var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIdentity,
        WithDetails,
        WithDeliveryType,
        WithDeliveryInfo {
            public JobResource create();

            public JobResource create(Context var1);
        }

        public static interface WithTransferType {
            public WithCreate withTransferType(TransferType var1);
        }

        public static interface WithSku {
            public WithTransferType withSku(Sku var1);
        }

        public static interface WithResourceGroup {
            public WithSku withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithSku,
    DefinitionStages.WithTransferType,
    DefinitionStages.WithCreate {
    }
}

