/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ClassDiscriminator;
import com.azure.resourcemanager.databox.models.ContactDetails;
import com.azure.resourcemanager.databox.models.CopyLogDetails;
import com.azure.resourcemanager.databox.models.CustomerResolutionCode;
import com.azure.resourcemanager.databox.models.DataBoxCustomerDiskJobDetails;
import com.azure.resourcemanager.databox.models.DataBoxDiskJobDetails;
import com.azure.resourcemanager.databox.models.DataBoxHeavyJobDetails;
import com.azure.resourcemanager.databox.models.DataBoxJobDetails;
import com.azure.resourcemanager.databox.models.DataCenterCode;
import com.azure.resourcemanager.databox.models.DataExportDetails;
import com.azure.resourcemanager.databox.models.DataImportDetails;
import com.azure.resourcemanager.databox.models.DatacenterAddressResponse;
import com.azure.resourcemanager.databox.models.DeviceErasureDetails;
import com.azure.resourcemanager.databox.models.JobStages;
import com.azure.resourcemanager.databox.models.KeyEncryptionKey;
import com.azure.resourcemanager.databox.models.LastMitigationActionOnJob;
import com.azure.resourcemanager.databox.models.PackageShippingDetails;
import com.azure.resourcemanager.databox.models.Preferences;
import com.azure.resourcemanager.databox.models.ReverseShippingDetails;
import com.azure.resourcemanager.databox.models.ShippingAddress;
import java.io.IOException;
import java.util.List;

public class JobDetails
implements JsonSerializable<JobDetails> {
    private ClassDiscriminator jobDetailsType;
    private List<JobStages> jobStages;
    private ContactDetails contactDetails;
    private ShippingAddress shippingAddress;
    private PackageShippingDetails deliveryPackage;
    private PackageShippingDetails returnPackage;
    private List<DataImportDetails> dataImportDetails;
    private List<DataExportDetails> dataExportDetails;
    private Preferences preferences;
    private ReverseShippingDetails reverseShippingDetails;
    private List<CopyLogDetails> copyLogDetails;
    private String reverseShipmentLabelSasKey;
    private String chainOfCustodySasKey;
    private DeviceErasureDetails deviceErasureDetails;
    private KeyEncryptionKey keyEncryptionKey;
    private Integer expectedDataSizeInTeraBytes;
    private List<CustomerResolutionCode> actions;
    private LastMitigationActionOnJob lastMitigationActionOnJob;
    private DatacenterAddressResponse datacenterAddress;
    private DataCenterCode dataCenterCode;
    private static final ClientLogger LOGGER = new ClientLogger(JobDetails.class);

    public ClassDiscriminator jobDetailsType() {
        return this.jobDetailsType;
    }

    public List<JobStages> jobStages() {
        return this.jobStages;
    }

    JobDetails withJobStages(List<JobStages> jobStages) {
        this.jobStages = jobStages;
        return this;
    }

    public ContactDetails contactDetails() {
        return this.contactDetails;
    }

    public JobDetails withContactDetails(ContactDetails contactDetails) {
        this.contactDetails = contactDetails;
        return this;
    }

    public ShippingAddress shippingAddress() {
        return this.shippingAddress;
    }

    public JobDetails withShippingAddress(ShippingAddress shippingAddress) {
        this.shippingAddress = shippingAddress;
        return this;
    }

    public PackageShippingDetails deliveryPackage() {
        return this.deliveryPackage;
    }

    JobDetails withDeliveryPackage(PackageShippingDetails deliveryPackage) {
        this.deliveryPackage = deliveryPackage;
        return this;
    }

    public PackageShippingDetails returnPackage() {
        return this.returnPackage;
    }

    JobDetails withReturnPackage(PackageShippingDetails returnPackage) {
        this.returnPackage = returnPackage;
        return this;
    }

    public List<DataImportDetails> dataImportDetails() {
        return this.dataImportDetails;
    }

    public JobDetails withDataImportDetails(List<DataImportDetails> dataImportDetails) {
        this.dataImportDetails = dataImportDetails;
        return this;
    }

    public List<DataExportDetails> dataExportDetails() {
        return this.dataExportDetails;
    }

    public JobDetails withDataExportDetails(List<DataExportDetails> dataExportDetails) {
        this.dataExportDetails = dataExportDetails;
        return this;
    }

    public Preferences preferences() {
        return this.preferences;
    }

    public JobDetails withPreferences(Preferences preferences) {
        this.preferences = preferences;
        return this;
    }

    public ReverseShippingDetails reverseShippingDetails() {
        return this.reverseShippingDetails;
    }

    public JobDetails withReverseShippingDetails(ReverseShippingDetails reverseShippingDetails) {
        this.reverseShippingDetails = reverseShippingDetails;
        return this;
    }

    public List<CopyLogDetails> copyLogDetails() {
        return this.copyLogDetails;
    }

    JobDetails withCopyLogDetails(List<CopyLogDetails> copyLogDetails) {
        this.copyLogDetails = copyLogDetails;
        return this;
    }

    public String reverseShipmentLabelSasKey() {
        return this.reverseShipmentLabelSasKey;
    }

    JobDetails withReverseShipmentLabelSasKey(String reverseShipmentLabelSasKey) {
        this.reverseShipmentLabelSasKey = reverseShipmentLabelSasKey;
        return this;
    }

    public String chainOfCustodySasKey() {
        return this.chainOfCustodySasKey;
    }

    JobDetails withChainOfCustodySasKey(String chainOfCustodySasKey) {
        this.chainOfCustodySasKey = chainOfCustodySasKey;
        return this;
    }

    public DeviceErasureDetails deviceErasureDetails() {
        return this.deviceErasureDetails;
    }

    JobDetails withDeviceErasureDetails(DeviceErasureDetails deviceErasureDetails) {
        this.deviceErasureDetails = deviceErasureDetails;
        return this;
    }

    public KeyEncryptionKey keyEncryptionKey() {
        return this.keyEncryptionKey;
    }

    public JobDetails withKeyEncryptionKey(KeyEncryptionKey keyEncryptionKey) {
        this.keyEncryptionKey = keyEncryptionKey;
        return this;
    }

    public Integer expectedDataSizeInTeraBytes() {
        return this.expectedDataSizeInTeraBytes;
    }

    public JobDetails withExpectedDataSizeInTeraBytes(Integer expectedDataSizeInTeraBytes) {
        this.expectedDataSizeInTeraBytes = expectedDataSizeInTeraBytes;
        return this;
    }

    public List<CustomerResolutionCode> actions() {
        return this.actions;
    }

    JobDetails withActions(List<CustomerResolutionCode> actions) {
        this.actions = actions;
        return this;
    }

    public LastMitigationActionOnJob lastMitigationActionOnJob() {
        return this.lastMitigationActionOnJob;
    }

    JobDetails withLastMitigationActionOnJob(LastMitigationActionOnJob lastMitigationActionOnJob) {
        this.lastMitigationActionOnJob = lastMitigationActionOnJob;
        return this;
    }

    public DatacenterAddressResponse datacenterAddress() {
        return this.datacenterAddress;
    }

    JobDetails withDatacenterAddress(DatacenterAddressResponse datacenterAddress) {
        this.datacenterAddress = datacenterAddress;
        return this;
    }

    public DataCenterCode dataCenterCode() {
        return this.dataCenterCode;
    }

    JobDetails withDataCenterCode(DataCenterCode dataCenterCode) {
        this.dataCenterCode = dataCenterCode;
        return this;
    }

    public void validate() {
        if (this.jobStages() != null) {
            this.jobStages().forEach(e -> e.validate());
        }
        if (this.contactDetails() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property contactDetails in model JobDetails"));
        }
        this.contactDetails().validate();
        if (this.shippingAddress() != null) {
            this.shippingAddress().validate();
        }
        if (this.deliveryPackage() != null) {
            this.deliveryPackage().validate();
        }
        if (this.returnPackage() != null) {
            this.returnPackage().validate();
        }
        if (this.dataImportDetails() != null) {
            this.dataImportDetails().forEach(e -> e.validate());
        }
        if (this.dataExportDetails() != null) {
            this.dataExportDetails().forEach(e -> e.validate());
        }
        if (this.preferences() != null) {
            this.preferences().validate();
        }
        if (this.reverseShippingDetails() != null) {
            this.reverseShippingDetails().validate();
        }
        if (this.copyLogDetails() != null) {
            this.copyLogDetails().forEach(e -> e.validate());
        }
        if (this.deviceErasureDetails() != null) {
            this.deviceErasureDetails().validate();
        }
        if (this.keyEncryptionKey() != null) {
            this.keyEncryptionKey().validate();
        }
        if (this.lastMitigationActionOnJob() != null) {
            this.lastMitigationActionOnJob().validate();
        }
        if (this.datacenterAddress() != null) {
            this.datacenterAddress().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("contactDetails", (JsonSerializable)this.contactDetails);
        jsonWriter.writeStringField("jobDetailsType", this.jobDetailsType == null ? null : this.jobDetailsType.toString());
        jsonWriter.writeJsonField("shippingAddress", (JsonSerializable)this.shippingAddress);
        jsonWriter.writeArrayField("dataImportDetails", this.dataImportDetails, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("dataExportDetails", this.dataExportDetails, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("preferences", (JsonSerializable)this.preferences);
        jsonWriter.writeJsonField("reverseShippingDetails", (JsonSerializable)this.reverseShippingDetails);
        jsonWriter.writeJsonField("keyEncryptionKey", (JsonSerializable)this.keyEncryptionKey);
        jsonWriter.writeNumberField("expectedDataSizeInTeraBytes", (Number)this.expectedDataSizeInTeraBytes);
        return jsonWriter.writeEndObject();
    }

    public static JobDetails fromJson(JsonReader jsonReader) throws IOException {
        return (JobDetails)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                JobDetails jobDetails;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("jobDetailsType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("DataBoxCustomerDisk".equals(discriminatorValue)) {
                    jobDetails = DataBoxCustomerDiskJobDetails.fromJson(readerToUse.reset());
                    return jobDetails;
                }
                if ("DataBoxDisk".equals(discriminatorValue)) {
                    jobDetails = DataBoxDiskJobDetails.fromJson(readerToUse.reset());
                    return jobDetails;
                }
                if ("DataBoxHeavy".equals(discriminatorValue)) {
                    jobDetails = DataBoxHeavyJobDetails.fromJson(readerToUse.reset());
                    return jobDetails;
                }
                if ("DataBox".equals(discriminatorValue)) {
                    jobDetails = DataBoxJobDetails.fromJson(readerToUse.reset());
                    return jobDetails;
                }
                jobDetails = JobDetails.fromJsonKnownDiscriminator(readerToUse.reset());
                return jobDetails;
            }
        });
    }

    static JobDetails fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (JobDetails)jsonReader.readObject(reader -> {
            JobDetails deserializedJobDetails = new JobDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contactDetails".equals(fieldName)) {
                    deserializedJobDetails.contactDetails = ContactDetails.fromJson(reader);
                    continue;
                }
                if ("jobDetailsType".equals(fieldName)) {
                    deserializedJobDetails.jobDetailsType = ClassDiscriminator.fromString(reader.getString());
                    continue;
                }
                if ("jobStages".equals(fieldName)) {
                    List jobStages;
                    deserializedJobDetails.jobStages = jobStages = reader.readArray(reader1 -> JobStages.fromJson(reader1));
                    continue;
                }
                if ("shippingAddress".equals(fieldName)) {
                    deserializedJobDetails.shippingAddress = ShippingAddress.fromJson(reader);
                    continue;
                }
                if ("deliveryPackage".equals(fieldName)) {
                    deserializedJobDetails.deliveryPackage = PackageShippingDetails.fromJson(reader);
                    continue;
                }
                if ("returnPackage".equals(fieldName)) {
                    deserializedJobDetails.returnPackage = PackageShippingDetails.fromJson(reader);
                    continue;
                }
                if ("dataImportDetails".equals(fieldName)) {
                    List dataImportDetails;
                    deserializedJobDetails.dataImportDetails = dataImportDetails = reader.readArray(reader1 -> DataImportDetails.fromJson(reader1));
                    continue;
                }
                if ("dataExportDetails".equals(fieldName)) {
                    List dataExportDetails;
                    deserializedJobDetails.dataExportDetails = dataExportDetails = reader.readArray(reader1 -> DataExportDetails.fromJson(reader1));
                    continue;
                }
                if ("preferences".equals(fieldName)) {
                    deserializedJobDetails.preferences = Preferences.fromJson(reader);
                    continue;
                }
                if ("reverseShippingDetails".equals(fieldName)) {
                    deserializedJobDetails.reverseShippingDetails = ReverseShippingDetails.fromJson(reader);
                    continue;
                }
                if ("copyLogDetails".equals(fieldName)) {
                    List copyLogDetails;
                    deserializedJobDetails.copyLogDetails = copyLogDetails = reader.readArray(reader1 -> CopyLogDetails.fromJson(reader1));
                    continue;
                }
                if ("reverseShipmentLabelSasKey".equals(fieldName)) {
                    deserializedJobDetails.reverseShipmentLabelSasKey = reader.getString();
                    continue;
                }
                if ("chainOfCustodySasKey".equals(fieldName)) {
                    deserializedJobDetails.chainOfCustodySasKey = reader.getString();
                    continue;
                }
                if ("deviceErasureDetails".equals(fieldName)) {
                    deserializedJobDetails.deviceErasureDetails = DeviceErasureDetails.fromJson(reader);
                    continue;
                }
                if ("keyEncryptionKey".equals(fieldName)) {
                    deserializedJobDetails.keyEncryptionKey = KeyEncryptionKey.fromJson(reader);
                    continue;
                }
                if ("expectedDataSizeInTeraBytes".equals(fieldName)) {
                    deserializedJobDetails.expectedDataSizeInTeraBytes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List actions;
                    deserializedJobDetails.actions = actions = reader.readArray(reader1 -> CustomerResolutionCode.fromString(reader1.getString()));
                    continue;
                }
                if ("lastMitigationActionOnJob".equals(fieldName)) {
                    deserializedJobDetails.lastMitigationActionOnJob = LastMitigationActionOnJob.fromJson(reader);
                    continue;
                }
                if ("datacenterAddress".equals(fieldName)) {
                    deserializedJobDetails.datacenterAddress = DatacenterAddressResponse.fromJson(reader);
                    continue;
                }
                if ("dataCenterCode".equals(fieldName)) {
                    deserializedJobDetails.dataCenterCode = DataCenterCode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobDetails;
        });
    }
}

