/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class JobDeliveryInfo
implements JsonSerializable<JobDeliveryInfo> {
    private OffsetDateTime scheduledDateTime;

    public OffsetDateTime scheduledDateTime() {
        return this.scheduledDateTime;
    }

    public JobDeliveryInfo withScheduledDateTime(OffsetDateTime scheduledDateTime) {
        this.scheduledDateTime = scheduledDateTime;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scheduledDateTime", this.scheduledDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.scheduledDateTime));
        return jsonWriter.writeEndObject();
    }

    public static JobDeliveryInfo fromJson(JsonReader jsonReader) throws IOException {
        return (JobDeliveryInfo)jsonReader.readObject(reader -> {
            JobDeliveryInfo deserializedJobDeliveryInfo = new JobDeliveryInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scheduledDateTime".equals(fieldName)) {
                    deserializedJobDeliveryInfo.scheduledDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobDeliveryInfo;
        });
    }
}

