/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.DelayNotificationStatus;
import com.azure.resourcemanager.databox.models.PortalDelayErrorCode;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class JobDelayDetails
implements JsonSerializable<JobDelayDetails> {
    private DelayNotificationStatus status;
    private PortalDelayErrorCode errorCode;
    private String description;
    private OffsetDateTime startTime;
    private OffsetDateTime resolutionTime;

    public DelayNotificationStatus status() {
        return this.status;
    }

    public PortalDelayErrorCode errorCode() {
        return this.errorCode;
    }

    public String description() {
        return this.description;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime resolutionTime() {
        return this.resolutionTime;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static JobDelayDetails fromJson(JsonReader jsonReader) throws IOException {
        return (JobDelayDetails)jsonReader.readObject(reader -> {
            JobDelayDetails deserializedJobDelayDetails = new JobDelayDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedJobDelayDetails.status = DelayNotificationStatus.fromString(reader.getString());
                    continue;
                }
                if ("errorCode".equals(fieldName)) {
                    deserializedJobDelayDetails.errorCode = PortalDelayErrorCode.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedJobDelayDetails.description = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedJobDelayDetails.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("resolutionTime".equals(fieldName)) {
                    deserializedJobDelayDetails.resolutionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobDelayDetails;
        });
    }
}

