/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ImportDiskDetails
implements JsonSerializable<ImportDiskDetails> {
    private String manifestFile;
    private String manifestHash;
    private String bitLockerKey;
    private String backupManifestCloudPath;
    private static final ClientLogger LOGGER = new ClientLogger(ImportDiskDetails.class);

    public String manifestFile() {
        return this.manifestFile;
    }

    public ImportDiskDetails withManifestFile(String manifestFile) {
        this.manifestFile = manifestFile;
        return this;
    }

    public String manifestHash() {
        return this.manifestHash;
    }

    public ImportDiskDetails withManifestHash(String manifestHash) {
        this.manifestHash = manifestHash;
        return this;
    }

    public String bitLockerKey() {
        return this.bitLockerKey;
    }

    public ImportDiskDetails withBitLockerKey(String bitLockerKey) {
        this.bitLockerKey = bitLockerKey;
        return this;
    }

    public String backupManifestCloudPath() {
        return this.backupManifestCloudPath;
    }

    public void validate() {
        if (this.manifestFile() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property manifestFile in model ImportDiskDetails"));
        }
        if (this.manifestHash() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property manifestHash in model ImportDiskDetails"));
        }
        if (this.bitLockerKey() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property bitLockerKey in model ImportDiskDetails"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("manifestFile", this.manifestFile);
        jsonWriter.writeStringField("manifestHash", this.manifestHash);
        jsonWriter.writeStringField("bitLockerKey", this.bitLockerKey);
        return jsonWriter.writeEndObject();
    }

    public static ImportDiskDetails fromJson(JsonReader jsonReader) throws IOException {
        return (ImportDiskDetails)jsonReader.readObject(reader -> {
            ImportDiskDetails deserializedImportDiskDetails = new ImportDiskDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("manifestFile".equals(fieldName)) {
                    deserializedImportDiskDetails.manifestFile = reader.getString();
                    continue;
                }
                if ("manifestHash".equals(fieldName)) {
                    deserializedImportDiskDetails.manifestHash = reader.getString();
                    continue;
                }
                if ("bitLockerKey".equals(fieldName)) {
                    deserializedImportDiskDetails.bitLockerKey = reader.getString();
                    continue;
                }
                if ("backupManifestCloudPath".equals(fieldName)) {
                    deserializedImportDiskDetails.backupManifestCloudPath = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImportDiskDetails;
        });
    }
}

