/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.UserAssignedProperties;
import java.io.IOException;

public final class IdentityProperties
implements JsonSerializable<IdentityProperties> {
    private String type;
    private UserAssignedProperties userAssigned;

    public String type() {
        return this.type;
    }

    public IdentityProperties withType(String type) {
        this.type = type;
        return this;
    }

    public UserAssignedProperties userAssigned() {
        return this.userAssigned;
    }

    public IdentityProperties withUserAssigned(UserAssignedProperties userAssigned) {
        this.userAssigned = userAssigned;
        return this;
    }

    public void validate() {
        if (this.userAssigned() != null) {
            this.userAssigned().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("userAssigned", (JsonSerializable)this.userAssigned);
        return jsonWriter.writeEndObject();
    }

    public static IdentityProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IdentityProperties)jsonReader.readObject(reader -> {
            IdentityProperties deserializedIdentityProperties = new IdentityProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedIdentityProperties.type = reader.getString();
                    continue;
                }
                if ("userAssigned".equals(fieldName)) {
                    deserializedIdentityProperties.userAssigned = UserAssignedProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIdentityProperties;
        });
    }
}

