/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ModelName;
import com.azure.resourcemanager.databox.models.ScheduleAvailabilityRequest;
import com.azure.resourcemanager.databox.models.SkuName;
import java.io.IOException;

public final class HeavyScheduleAvailabilityRequest
extends ScheduleAvailabilityRequest {
    private SkuName skuName = SkuName.DATA_BOX_HEAVY;
    private static final ClientLogger LOGGER = new ClientLogger(HeavyScheduleAvailabilityRequest.class);

    @Override
    public SkuName skuName() {
        return this.skuName;
    }

    @Override
    public HeavyScheduleAvailabilityRequest withStorageLocation(String storageLocation) {
        super.withStorageLocation(storageLocation);
        return this;
    }

    @Override
    public HeavyScheduleAvailabilityRequest withCountry(String country) {
        super.withCountry(country);
        return this;
    }

    @Override
    public HeavyScheduleAvailabilityRequest withModel(ModelName model) {
        super.withModel(model);
        return this;
    }

    @Override
    public void validate() {
        if (this.storageLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageLocation in model HeavyScheduleAvailabilityRequest"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageLocation", this.storageLocation());
        jsonWriter.writeStringField("country", this.country());
        jsonWriter.writeStringField("model", this.model() == null ? null : this.model().toString());
        jsonWriter.writeStringField("skuName", this.skuName == null ? null : this.skuName.toString());
        return jsonWriter.writeEndObject();
    }

    public static HeavyScheduleAvailabilityRequest fromJson(JsonReader jsonReader) throws IOException {
        return (HeavyScheduleAvailabilityRequest)jsonReader.readObject(reader -> {
            HeavyScheduleAvailabilityRequest deserializedHeavyScheduleAvailabilityRequest = new HeavyScheduleAvailabilityRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageLocation".equals(fieldName)) {
                    deserializedHeavyScheduleAvailabilityRequest.withStorageLocation(reader.getString());
                    continue;
                }
                if ("country".equals(fieldName)) {
                    deserializedHeavyScheduleAvailabilityRequest.withCountry(reader.getString());
                    continue;
                }
                if ("model".equals(fieldName)) {
                    deserializedHeavyScheduleAvailabilityRequest.withModel(ModelName.fromString(reader.getString()));
                    continue;
                }
                if ("skuName".equals(fieldName)) {
                    deserializedHeavyScheduleAvailabilityRequest.skuName = SkuName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHeavyScheduleAvailabilityRequest;
        });
    }
}

