/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.CloudError;
import com.azure.resourcemanager.databox.models.CustomerResolutionCode;
import com.azure.resourcemanager.databox.models.DataAccountType;
import com.azure.resourcemanager.databox.models.TransferType;
import java.io.IOException;
import java.util.List;

public class GranularCopyProgress
implements JsonSerializable<GranularCopyProgress> {
    private String storageAccountName;
    private TransferType transferType;
    private DataAccountType dataAccountType;
    private String accountId;
    private Long bytesProcessed;
    private Long totalBytesToProcess;
    private Long filesProcessed;
    private Long totalFilesToProcess;
    private Long invalidFilesProcessed;
    private Long invalidFileBytesUploaded;
    private Long renamedContainerCount;
    private Long filesErroredOut;
    private Long directoriesErroredOut;
    private Long invalidDirectoriesProcessed;
    private Boolean isEnumerationInProgress;
    private CloudError error;
    private List<CustomerResolutionCode> actions;

    public String storageAccountName() {
        return this.storageAccountName;
    }

    GranularCopyProgress withStorageAccountName(String storageAccountName) {
        this.storageAccountName = storageAccountName;
        return this;
    }

    public TransferType transferType() {
        return this.transferType;
    }

    GranularCopyProgress withTransferType(TransferType transferType) {
        this.transferType = transferType;
        return this;
    }

    public DataAccountType dataAccountType() {
        return this.dataAccountType;
    }

    GranularCopyProgress withDataAccountType(DataAccountType dataAccountType) {
        this.dataAccountType = dataAccountType;
        return this;
    }

    public String accountId() {
        return this.accountId;
    }

    GranularCopyProgress withAccountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    public Long bytesProcessed() {
        return this.bytesProcessed;
    }

    GranularCopyProgress withBytesProcessed(Long bytesProcessed) {
        this.bytesProcessed = bytesProcessed;
        return this;
    }

    public Long totalBytesToProcess() {
        return this.totalBytesToProcess;
    }

    GranularCopyProgress withTotalBytesToProcess(Long totalBytesToProcess) {
        this.totalBytesToProcess = totalBytesToProcess;
        return this;
    }

    public Long filesProcessed() {
        return this.filesProcessed;
    }

    GranularCopyProgress withFilesProcessed(Long filesProcessed) {
        this.filesProcessed = filesProcessed;
        return this;
    }

    public Long totalFilesToProcess() {
        return this.totalFilesToProcess;
    }

    GranularCopyProgress withTotalFilesToProcess(Long totalFilesToProcess) {
        this.totalFilesToProcess = totalFilesToProcess;
        return this;
    }

    public Long invalidFilesProcessed() {
        return this.invalidFilesProcessed;
    }

    GranularCopyProgress withInvalidFilesProcessed(Long invalidFilesProcessed) {
        this.invalidFilesProcessed = invalidFilesProcessed;
        return this;
    }

    public Long invalidFileBytesUploaded() {
        return this.invalidFileBytesUploaded;
    }

    GranularCopyProgress withInvalidFileBytesUploaded(Long invalidFileBytesUploaded) {
        this.invalidFileBytesUploaded = invalidFileBytesUploaded;
        return this;
    }

    public Long renamedContainerCount() {
        return this.renamedContainerCount;
    }

    GranularCopyProgress withRenamedContainerCount(Long renamedContainerCount) {
        this.renamedContainerCount = renamedContainerCount;
        return this;
    }

    public Long filesErroredOut() {
        return this.filesErroredOut;
    }

    GranularCopyProgress withFilesErroredOut(Long filesErroredOut) {
        this.filesErroredOut = filesErroredOut;
        return this;
    }

    public Long directoriesErroredOut() {
        return this.directoriesErroredOut;
    }

    GranularCopyProgress withDirectoriesErroredOut(Long directoriesErroredOut) {
        this.directoriesErroredOut = directoriesErroredOut;
        return this;
    }

    public Long invalidDirectoriesProcessed() {
        return this.invalidDirectoriesProcessed;
    }

    GranularCopyProgress withInvalidDirectoriesProcessed(Long invalidDirectoriesProcessed) {
        this.invalidDirectoriesProcessed = invalidDirectoriesProcessed;
        return this;
    }

    public Boolean isEnumerationInProgress() {
        return this.isEnumerationInProgress;
    }

    GranularCopyProgress withIsEnumerationInProgress(Boolean isEnumerationInProgress) {
        this.isEnumerationInProgress = isEnumerationInProgress;
        return this;
    }

    public CloudError error() {
        return this.error;
    }

    GranularCopyProgress withError(CloudError error) {
        this.error = error;
        return this;
    }

    public List<CustomerResolutionCode> actions() {
        return this.actions;
    }

    GranularCopyProgress withActions(List<CustomerResolutionCode> actions) {
        this.actions = actions;
        return this;
    }

    public void validate() {
        if (this.error() != null) {
            this.error().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static GranularCopyProgress fromJson(JsonReader jsonReader) throws IOException {
        return (GranularCopyProgress)jsonReader.readObject(reader -> {
            GranularCopyProgress deserializedGranularCopyProgress = new GranularCopyProgress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageAccountName".equals(fieldName)) {
                    deserializedGranularCopyProgress.storageAccountName = reader.getString();
                    continue;
                }
                if ("transferType".equals(fieldName)) {
                    deserializedGranularCopyProgress.transferType = TransferType.fromString(reader.getString());
                    continue;
                }
                if ("dataAccountType".equals(fieldName)) {
                    deserializedGranularCopyProgress.dataAccountType = DataAccountType.fromString(reader.getString());
                    continue;
                }
                if ("accountId".equals(fieldName)) {
                    deserializedGranularCopyProgress.accountId = reader.getString();
                    continue;
                }
                if ("bytesProcessed".equals(fieldName)) {
                    deserializedGranularCopyProgress.bytesProcessed = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("totalBytesToProcess".equals(fieldName)) {
                    deserializedGranularCopyProgress.totalBytesToProcess = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("filesProcessed".equals(fieldName)) {
                    deserializedGranularCopyProgress.filesProcessed = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("totalFilesToProcess".equals(fieldName)) {
                    deserializedGranularCopyProgress.totalFilesToProcess = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("invalidFilesProcessed".equals(fieldName)) {
                    deserializedGranularCopyProgress.invalidFilesProcessed = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("invalidFileBytesUploaded".equals(fieldName)) {
                    deserializedGranularCopyProgress.invalidFileBytesUploaded = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("renamedContainerCount".equals(fieldName)) {
                    deserializedGranularCopyProgress.renamedContainerCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("filesErroredOut".equals(fieldName)) {
                    deserializedGranularCopyProgress.filesErroredOut = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("directoriesErroredOut".equals(fieldName)) {
                    deserializedGranularCopyProgress.directoriesErroredOut = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("invalidDirectoriesProcessed".equals(fieldName)) {
                    deserializedGranularCopyProgress.invalidDirectoriesProcessed = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("isEnumerationInProgress".equals(fieldName)) {
                    deserializedGranularCopyProgress.isEnumerationInProgress = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedGranularCopyProgress.error = CloudError.fromJson(reader);
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List actions;
                    deserializedGranularCopyProgress.actions = actions = reader.readArray(reader1 -> CustomerResolutionCode.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGranularCopyProgress;
        });
    }
}

