/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.FilterFileType;
import java.io.IOException;

public final class FilterFileDetails
implements JsonSerializable<FilterFileDetails> {
    private FilterFileType filterFileType;
    private String filterFilePath;
    private static final ClientLogger LOGGER = new ClientLogger(FilterFileDetails.class);

    public FilterFileType filterFileType() {
        return this.filterFileType;
    }

    public FilterFileDetails withFilterFileType(FilterFileType filterFileType) {
        this.filterFileType = filterFileType;
        return this;
    }

    public String filterFilePath() {
        return this.filterFilePath;
    }

    public FilterFileDetails withFilterFilePath(String filterFilePath) {
        this.filterFilePath = filterFilePath;
        return this;
    }

    public void validate() {
        if (this.filterFileType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property filterFileType in model FilterFileDetails"));
        }
        if (this.filterFilePath() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property filterFilePath in model FilterFileDetails"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("filterFileType", this.filterFileType == null ? null : this.filterFileType.toString());
        jsonWriter.writeStringField("filterFilePath", this.filterFilePath);
        return jsonWriter.writeEndObject();
    }

    public static FilterFileDetails fromJson(JsonReader jsonReader) throws IOException {
        return (FilterFileDetails)jsonReader.readObject(reader -> {
            FilterFileDetails deserializedFilterFileDetails = new FilterFileDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filterFileType".equals(fieldName)) {
                    deserializedFilterFileDetails.filterFileType = FilterFileType.fromString(reader.getString());
                    continue;
                }
                if ("filterFilePath".equals(fieldName)) {
                    deserializedFilterFileDetails.filterFilePath = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFilterFileDetails;
        });
    }
}

