/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ModelName;
import com.azure.resourcemanager.databox.models.ScheduleAvailabilityRequest;
import com.azure.resourcemanager.databox.models.SkuName;
import java.io.IOException;

public final class DiskScheduleAvailabilityRequest
extends ScheduleAvailabilityRequest {
    private SkuName skuName = SkuName.DATA_BOX_DISK;
    private int expectedDataSizeInTeraBytes;
    private static final ClientLogger LOGGER = new ClientLogger(DiskScheduleAvailabilityRequest.class);

    @Override
    public SkuName skuName() {
        return this.skuName;
    }

    public int expectedDataSizeInTeraBytes() {
        return this.expectedDataSizeInTeraBytes;
    }

    public DiskScheduleAvailabilityRequest withExpectedDataSizeInTeraBytes(int expectedDataSizeInTeraBytes) {
        this.expectedDataSizeInTeraBytes = expectedDataSizeInTeraBytes;
        return this;
    }

    @Override
    public DiskScheduleAvailabilityRequest withStorageLocation(String storageLocation) {
        super.withStorageLocation(storageLocation);
        return this;
    }

    @Override
    public DiskScheduleAvailabilityRequest withCountry(String country) {
        super.withCountry(country);
        return this;
    }

    @Override
    public DiskScheduleAvailabilityRequest withModel(ModelName model) {
        super.withModel(model);
        return this;
    }

    @Override
    public void validate() {
        if (this.storageLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageLocation in model DiskScheduleAvailabilityRequest"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageLocation", this.storageLocation());
        jsonWriter.writeStringField("country", this.country());
        jsonWriter.writeStringField("model", this.model() == null ? null : this.model().toString());
        jsonWriter.writeIntField("expectedDataSizeInTeraBytes", this.expectedDataSizeInTeraBytes);
        jsonWriter.writeStringField("skuName", this.skuName == null ? null : this.skuName.toString());
        return jsonWriter.writeEndObject();
    }

    public static DiskScheduleAvailabilityRequest fromJson(JsonReader jsonReader) throws IOException {
        return (DiskScheduleAvailabilityRequest)jsonReader.readObject(reader -> {
            DiskScheduleAvailabilityRequest deserializedDiskScheduleAvailabilityRequest = new DiskScheduleAvailabilityRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageLocation".equals(fieldName)) {
                    deserializedDiskScheduleAvailabilityRequest.withStorageLocation(reader.getString());
                    continue;
                }
                if ("country".equals(fieldName)) {
                    deserializedDiskScheduleAvailabilityRequest.withCountry(reader.getString());
                    continue;
                }
                if ("model".equals(fieldName)) {
                    deserializedDiskScheduleAvailabilityRequest.withModel(ModelName.fromString(reader.getString()));
                    continue;
                }
                if ("expectedDataSizeInTeraBytes".equals(fieldName)) {
                    deserializedDiskScheduleAvailabilityRequest.expectedDataSizeInTeraBytes = reader.getInt();
                    continue;
                }
                if ("skuName".equals(fieldName)) {
                    deserializedDiskScheduleAvailabilityRequest.skuName = SkuName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiskScheduleAvailabilityRequest;
        });
    }
}

