/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ModelName;
import com.azure.resourcemanager.databox.models.SkuName;
import java.io.IOException;

public final class DeviceCapabilityRequest
implements JsonSerializable<DeviceCapabilityRequest> {
    private SkuName skuName;
    private ModelName model;

    public SkuName skuName() {
        return this.skuName;
    }

    public DeviceCapabilityRequest withSkuName(SkuName skuName) {
        this.skuName = skuName;
        return this;
    }

    public ModelName model() {
        return this.model;
    }

    public DeviceCapabilityRequest withModel(ModelName model) {
        this.model = model;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("skuName", this.skuName == null ? null : this.skuName.toString());
        jsonWriter.writeStringField("model", this.model == null ? null : this.model.toString());
        return jsonWriter.writeEndObject();
    }

    public static DeviceCapabilityRequest fromJson(JsonReader jsonReader) throws IOException {
        return (DeviceCapabilityRequest)jsonReader.readObject(reader -> {
            DeviceCapabilityRequest deserializedDeviceCapabilityRequest = new DeviceCapabilityRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("skuName".equals(fieldName)) {
                    deserializedDeviceCapabilityRequest.skuName = SkuName.fromString(reader.getString());
                    continue;
                }
                if ("model".equals(fieldName)) {
                    deserializedDeviceCapabilityRequest.model = ModelName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeviceCapabilityRequest;
        });
    }
}

