/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.DatacenterAddressInstructionResponse;
import com.azure.resourcemanager.databox.models.DatacenterAddressLocationResponse;
import com.azure.resourcemanager.databox.models.DatacenterAddressType;
import java.io.IOException;
import java.util.List;

public class DatacenterAddressResponse
implements JsonSerializable<DatacenterAddressResponse> {
    private DatacenterAddressType datacenterAddressType;
    private List<String> supportedCarriersForReturnShipment;
    private String dataCenterAzureLocation;

    public DatacenterAddressType datacenterAddressType() {
        return this.datacenterAddressType;
    }

    public List<String> supportedCarriersForReturnShipment() {
        return this.supportedCarriersForReturnShipment;
    }

    DatacenterAddressResponse withSupportedCarriersForReturnShipment(List<String> supportedCarriersForReturnShipment) {
        this.supportedCarriersForReturnShipment = supportedCarriersForReturnShipment;
        return this;
    }

    public String dataCenterAzureLocation() {
        return this.dataCenterAzureLocation;
    }

    DatacenterAddressResponse withDataCenterAzureLocation(String dataCenterAzureLocation) {
        this.dataCenterAzureLocation = dataCenterAzureLocation;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("datacenterAddressType", this.datacenterAddressType == null ? null : this.datacenterAddressType.toString());
        return jsonWriter.writeEndObject();
    }

    public static DatacenterAddressResponse fromJson(JsonReader jsonReader) throws IOException {
        return (DatacenterAddressResponse)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                DatacenterAddressResponse datacenterAddressResponse;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("datacenterAddressType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("DatacenterAddressInstruction".equals(discriminatorValue)) {
                    datacenterAddressResponse = DatacenterAddressInstructionResponse.fromJson(readerToUse.reset());
                    return datacenterAddressResponse;
                }
                if ("DatacenterAddressLocation".equals(discriminatorValue)) {
                    datacenterAddressResponse = DatacenterAddressLocationResponse.fromJson(readerToUse.reset());
                    return datacenterAddressResponse;
                }
                datacenterAddressResponse = DatacenterAddressResponse.fromJsonKnownDiscriminator(readerToUse.reset());
                return datacenterAddressResponse;
            }
        });
    }

    static DatacenterAddressResponse fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (DatacenterAddressResponse)jsonReader.readObject(reader -> {
            DatacenterAddressResponse deserializedDatacenterAddressResponse = new DatacenterAddressResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("datacenterAddressType".equals(fieldName)) {
                    deserializedDatacenterAddressResponse.datacenterAddressType = DatacenterAddressType.fromString(reader.getString());
                    continue;
                }
                if ("supportedCarriersForReturnShipment".equals(fieldName)) {
                    List supportedCarriersForReturnShipment;
                    deserializedDatacenterAddressResponse.supportedCarriersForReturnShipment = supportedCarriersForReturnShipment = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("dataCenterAzureLocation".equals(fieldName)) {
                    deserializedDatacenterAddressResponse.dataCenterAzureLocation = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatacenterAddressResponse;
        });
    }
}

