/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ModelName;
import com.azure.resourcemanager.databox.models.SkuName;
import java.io.IOException;

public final class DatacenterAddressRequest
implements JsonSerializable<DatacenterAddressRequest> {
    private String storageLocation;
    private SkuName skuName;
    private ModelName model;
    private static final ClientLogger LOGGER = new ClientLogger(DatacenterAddressRequest.class);

    public String storageLocation() {
        return this.storageLocation;
    }

    public DatacenterAddressRequest withStorageLocation(String storageLocation) {
        this.storageLocation = storageLocation;
        return this;
    }

    public SkuName skuName() {
        return this.skuName;
    }

    public DatacenterAddressRequest withSkuName(SkuName skuName) {
        this.skuName = skuName;
        return this;
    }

    public ModelName model() {
        return this.model;
    }

    public DatacenterAddressRequest withModel(ModelName model) {
        this.model = model;
        return this;
    }

    public void validate() {
        if (this.storageLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageLocation in model DatacenterAddressRequest"));
        }
        if (this.skuName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property skuName in model DatacenterAddressRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageLocation", this.storageLocation);
        jsonWriter.writeStringField("skuName", this.skuName == null ? null : this.skuName.toString());
        jsonWriter.writeStringField("model", this.model == null ? null : this.model.toString());
        return jsonWriter.writeEndObject();
    }

    public static DatacenterAddressRequest fromJson(JsonReader jsonReader) throws IOException {
        return (DatacenterAddressRequest)jsonReader.readObject(reader -> {
            DatacenterAddressRequest deserializedDatacenterAddressRequest = new DatacenterAddressRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageLocation".equals(fieldName)) {
                    deserializedDatacenterAddressRequest.storageLocation = reader.getString();
                    continue;
                }
                if ("skuName".equals(fieldName)) {
                    deserializedDatacenterAddressRequest.skuName = SkuName.fromString(reader.getString());
                    continue;
                }
                if ("model".equals(fieldName)) {
                    deserializedDatacenterAddressRequest.model = ModelName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatacenterAddressRequest;
        });
    }
}

