/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.DatacenterAddressResponse;
import com.azure.resourcemanager.databox.models.DatacenterAddressType;
import java.io.IOException;
import java.util.List;

public final class DatacenterAddressLocationResponse
extends DatacenterAddressResponse {
    private DatacenterAddressType datacenterAddressType = DatacenterAddressType.DATACENTER_ADDRESS_LOCATION;
    private String contactPersonName;
    private String company;
    private String street1;
    private String street2;
    private String street3;
    private String city;
    private String state;
    private String zip;
    private String country;
    private String phone;
    private String phoneExtension;
    private String addressType;
    private String additionalShippingInformation;

    @Override
    public DatacenterAddressType datacenterAddressType() {
        return this.datacenterAddressType;
    }

    public String contactPersonName() {
        return this.contactPersonName;
    }

    public String company() {
        return this.company;
    }

    public String street1() {
        return this.street1;
    }

    public String street2() {
        return this.street2;
    }

    public String street3() {
        return this.street3;
    }

    public String city() {
        return this.city;
    }

    public String state() {
        return this.state;
    }

    public String zip() {
        return this.zip;
    }

    public String country() {
        return this.country;
    }

    public String phone() {
        return this.phone;
    }

    public String phoneExtension() {
        return this.phoneExtension;
    }

    public String addressType() {
        return this.addressType;
    }

    public String additionalShippingInformation() {
        return this.additionalShippingInformation;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("datacenterAddressType", this.datacenterAddressType == null ? null : this.datacenterAddressType.toString());
        return jsonWriter.writeEndObject();
    }

    public static DatacenterAddressLocationResponse fromJson(JsonReader jsonReader) throws IOException {
        return (DatacenterAddressLocationResponse)jsonReader.readObject(reader -> {
            DatacenterAddressLocationResponse deserializedDatacenterAddressLocationResponse = new DatacenterAddressLocationResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("supportedCarriersForReturnShipment".equals(fieldName)) {
                    List supportedCarriersForReturnShipment = reader.readArray(reader1 -> reader1.getString());
                    deserializedDatacenterAddressLocationResponse.withSupportedCarriersForReturnShipment(supportedCarriersForReturnShipment);
                    continue;
                }
                if ("dataCenterAzureLocation".equals(fieldName)) {
                    deserializedDatacenterAddressLocationResponse.withDataCenterAzureLocation(reader.getString());
                    continue;
                }
                if ("datacenterAddressType".equals(fieldName)) {
                    deserializedDatacenterAddressLocationResponse.datacenterAddressType = DatacenterAddressType.fromString(reader.getString());
                    continue;
                }
                if ("contactPersonName".equals(fieldName)) {
                    deserializedDatacenterAddressLocationResponse.contactPersonName = reader.getString();
                    continue;
                }
                if ("company".equals(fieldName)) {
                    deserializedDatacenterAddressLocationResponse.company = reader.getString();
                    continue;
                }
                if ("street1".equals(fieldName)) {
                    deserializedDatacenterAddressLocationResponse.street1 = reader.getString();
                    continue;
                }
                if ("street2".equals(fieldName)) {
                    deserializedDatacenterAddressLocationResponse.street2 = reader.getString();
                    continue;
                }
                if ("street3".equals(fieldName)) {
                    deserializedDatacenterAddressLocationResponse.street3 = reader.getString();
                    continue;
                }
                if ("city".equals(fieldName)) {
                    deserializedDatacenterAddressLocationResponse.city = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedDatacenterAddressLocationResponse.state = reader.getString();
                    continue;
                }
                if ("zip".equals(fieldName)) {
                    deserializedDatacenterAddressLocationResponse.zip = reader.getString();
                    continue;
                }
                if ("country".equals(fieldName)) {
                    deserializedDatacenterAddressLocationResponse.country = reader.getString();
                    continue;
                }
                if ("phone".equals(fieldName)) {
                    deserializedDatacenterAddressLocationResponse.phone = reader.getString();
                    continue;
                }
                if ("phoneExtension".equals(fieldName)) {
                    deserializedDatacenterAddressLocationResponse.phoneExtension = reader.getString();
                    continue;
                }
                if ("addressType".equals(fieldName)) {
                    deserializedDatacenterAddressLocationResponse.addressType = reader.getString();
                    continue;
                }
                if ("additionalShippingInformation".equals(fieldName)) {
                    deserializedDatacenterAddressLocationResponse.additionalShippingInformation = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatacenterAddressLocationResponse;
        });
    }
}

