/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.DatacenterAddressResponse;
import com.azure.resourcemanager.databox.models.DatacenterAddressType;
import java.io.IOException;
import java.util.List;

public final class DatacenterAddressInstructionResponse
extends DatacenterAddressResponse {
    private DatacenterAddressType datacenterAddressType = DatacenterAddressType.DATACENTER_ADDRESS_INSTRUCTION;
    private String communicationInstruction;

    @Override
    public DatacenterAddressType datacenterAddressType() {
        return this.datacenterAddressType;
    }

    public String communicationInstruction() {
        return this.communicationInstruction;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("datacenterAddressType", this.datacenterAddressType == null ? null : this.datacenterAddressType.toString());
        return jsonWriter.writeEndObject();
    }

    public static DatacenterAddressInstructionResponse fromJson(JsonReader jsonReader) throws IOException {
        return (DatacenterAddressInstructionResponse)jsonReader.readObject(reader -> {
            DatacenterAddressInstructionResponse deserializedDatacenterAddressInstructionResponse = new DatacenterAddressInstructionResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("supportedCarriersForReturnShipment".equals(fieldName)) {
                    List supportedCarriersForReturnShipment = reader.readArray(reader1 -> reader1.getString());
                    deserializedDatacenterAddressInstructionResponse.withSupportedCarriersForReturnShipment(supportedCarriersForReturnShipment);
                    continue;
                }
                if ("dataCenterAzureLocation".equals(fieldName)) {
                    deserializedDatacenterAddressInstructionResponse.withDataCenterAzureLocation(reader.getString());
                    continue;
                }
                if ("datacenterAddressType".equals(fieldName)) {
                    deserializedDatacenterAddressInstructionResponse.datacenterAddressType = DatacenterAddressType.fromString(reader.getString());
                    continue;
                }
                if ("communicationInstruction".equals(fieldName)) {
                    deserializedDatacenterAddressInstructionResponse.communicationInstruction = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatacenterAddressInstructionResponse;
        });
    }
}

