/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ClassDiscriminator;
import com.azure.resourcemanager.databox.models.CloudError;
import com.azure.resourcemanager.databox.models.DataBoxSecret;
import com.azure.resourcemanager.databox.models.DcAccessSecurityCode;
import com.azure.resourcemanager.databox.models.JobSecrets;
import java.io.IOException;
import java.util.List;

public final class DataboxJobSecrets
extends JobSecrets {
    private ClassDiscriminator jobSecretsType = ClassDiscriminator.DATA_BOX;
    private List<DataBoxSecret> podSecrets;

    @Override
    public ClassDiscriminator jobSecretsType() {
        return this.jobSecretsType;
    }

    public List<DataBoxSecret> podSecrets() {
        return this.podSecrets;
    }

    public DataboxJobSecrets withPodSecrets(List<DataBoxSecret> podSecrets) {
        this.podSecrets = podSecrets;
        return this;
    }

    @Override
    public void validate() {
        if (this.podSecrets() != null) {
            this.podSecrets().forEach(e -> e.validate());
        }
        if (this.dcAccessSecurityCode() != null) {
            this.dcAccessSecurityCode().validate();
        }
        if (this.error() != null) {
            this.error().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("jobSecretsType", this.jobSecretsType == null ? null : this.jobSecretsType.toString());
        jsonWriter.writeArrayField("podSecrets", this.podSecrets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DataboxJobSecrets fromJson(JsonReader jsonReader) throws IOException {
        return (DataboxJobSecrets)jsonReader.readObject(reader -> {
            DataboxJobSecrets deserializedDataboxJobSecrets = new DataboxJobSecrets();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dcAccessSecurityCode".equals(fieldName)) {
                    deserializedDataboxJobSecrets.withDcAccessSecurityCode(DcAccessSecurityCode.fromJson(reader));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedDataboxJobSecrets.withError(CloudError.fromJson(reader));
                    continue;
                }
                if ("jobSecretsType".equals(fieldName)) {
                    deserializedDataboxJobSecrets.jobSecretsType = ClassDiscriminator.fromString(reader.getString());
                    continue;
                }
                if ("podSecrets".equals(fieldName)) {
                    List podSecrets;
                    deserializedDataboxJobSecrets.podSecrets = podSecrets = reader.readArray(reader1 -> DataBoxSecret.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataboxJobSecrets;
        });
    }
}

