/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.CloudError;
import com.azure.resourcemanager.databox.models.ValidationInputDiscriminator;
import com.azure.resourcemanager.databox.models.ValidationInputResponse;
import com.azure.resourcemanager.databox.models.ValidationStatus;
import java.io.IOException;

public final class DataTransferDetailsValidationResponseProperties
extends ValidationInputResponse {
    private ValidationInputDiscriminator validationType = ValidationInputDiscriminator.VALIDATE_DATA_TRANSFER_DETAILS;
    private ValidationStatus status;

    @Override
    public ValidationInputDiscriminator validationType() {
        return this.validationType;
    }

    public ValidationStatus status() {
        return this.status;
    }

    @Override
    public void validate() {
        if (this.error() != null) {
            this.error().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("validationType", this.validationType == null ? null : this.validationType.toString());
        return jsonWriter.writeEndObject();
    }

    public static DataTransferDetailsValidationResponseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DataTransferDetailsValidationResponseProperties)jsonReader.readObject(reader -> {
            DataTransferDetailsValidationResponseProperties deserializedDataTransferDetailsValidationResponseProperties = new DataTransferDetailsValidationResponseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("error".equals(fieldName)) {
                    deserializedDataTransferDetailsValidationResponseProperties.withError(CloudError.fromJson(reader));
                    continue;
                }
                if ("validationType".equals(fieldName)) {
                    deserializedDataTransferDetailsValidationResponseProperties.validationType = ValidationInputDiscriminator.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedDataTransferDetailsValidationResponseProperties.status = ValidationStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataTransferDetailsValidationResponseProperties;
        });
    }
}

