/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.DataExportDetails;
import com.azure.resourcemanager.databox.models.DataImportDetails;
import com.azure.resourcemanager.databox.models.ModelName;
import com.azure.resourcemanager.databox.models.SkuName;
import com.azure.resourcemanager.databox.models.TransferType;
import com.azure.resourcemanager.databox.models.ValidationInputDiscriminator;
import com.azure.resourcemanager.databox.models.ValidationInputRequest;
import java.io.IOException;
import java.util.List;

public final class DataTransferDetailsValidationRequest
extends ValidationInputRequest {
    private ValidationInputDiscriminator validationType = ValidationInputDiscriminator.VALIDATE_DATA_TRANSFER_DETAILS;
    private List<DataExportDetails> dataExportDetails;
    private List<DataImportDetails> dataImportDetails;
    private SkuName deviceType;
    private TransferType transferType;
    private ModelName model;
    private static final ClientLogger LOGGER = new ClientLogger(DataTransferDetailsValidationRequest.class);

    @Override
    public ValidationInputDiscriminator validationType() {
        return this.validationType;
    }

    public List<DataExportDetails> dataExportDetails() {
        return this.dataExportDetails;
    }

    public DataTransferDetailsValidationRequest withDataExportDetails(List<DataExportDetails> dataExportDetails) {
        this.dataExportDetails = dataExportDetails;
        return this;
    }

    public List<DataImportDetails> dataImportDetails() {
        return this.dataImportDetails;
    }

    public DataTransferDetailsValidationRequest withDataImportDetails(List<DataImportDetails> dataImportDetails) {
        this.dataImportDetails = dataImportDetails;
        return this;
    }

    public SkuName deviceType() {
        return this.deviceType;
    }

    public DataTransferDetailsValidationRequest withDeviceType(SkuName deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public TransferType transferType() {
        return this.transferType;
    }

    public DataTransferDetailsValidationRequest withTransferType(TransferType transferType) {
        this.transferType = transferType;
        return this;
    }

    public ModelName model() {
        return this.model;
    }

    public DataTransferDetailsValidationRequest withModel(ModelName model) {
        this.model = model;
        return this;
    }

    @Override
    public void validate() {
        if (this.dataExportDetails() != null) {
            this.dataExportDetails().forEach(e -> e.validate());
        }
        if (this.dataImportDetails() != null) {
            this.dataImportDetails().forEach(e -> e.validate());
        }
        if (this.deviceType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property deviceType in model DataTransferDetailsValidationRequest"));
        }
        if (this.transferType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property transferType in model DataTransferDetailsValidationRequest"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("deviceType", this.deviceType == null ? null : this.deviceType.toString());
        jsonWriter.writeStringField("transferType", this.transferType == null ? null : this.transferType.toString());
        jsonWriter.writeStringField("validationType", this.validationType == null ? null : this.validationType.toString());
        jsonWriter.writeArrayField("dataExportDetails", this.dataExportDetails, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("dataImportDetails", this.dataImportDetails, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("model", this.model == null ? null : this.model.toString());
        return jsonWriter.writeEndObject();
    }

    public static DataTransferDetailsValidationRequest fromJson(JsonReader jsonReader) throws IOException {
        return (DataTransferDetailsValidationRequest)jsonReader.readObject(reader -> {
            DataTransferDetailsValidationRequest deserializedDataTransferDetailsValidationRequest = new DataTransferDetailsValidationRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deviceType".equals(fieldName)) {
                    deserializedDataTransferDetailsValidationRequest.deviceType = SkuName.fromString(reader.getString());
                    continue;
                }
                if ("transferType".equals(fieldName)) {
                    deserializedDataTransferDetailsValidationRequest.transferType = TransferType.fromString(reader.getString());
                    continue;
                }
                if ("validationType".equals(fieldName)) {
                    deserializedDataTransferDetailsValidationRequest.validationType = ValidationInputDiscriminator.fromString(reader.getString());
                    continue;
                }
                if ("dataExportDetails".equals(fieldName)) {
                    List dataExportDetails;
                    deserializedDataTransferDetailsValidationRequest.dataExportDetails = dataExportDetails = reader.readArray(reader1 -> DataExportDetails.fromJson(reader1));
                    continue;
                }
                if ("dataImportDetails".equals(fieldName)) {
                    List dataImportDetails;
                    deserializedDataTransferDetailsValidationRequest.dataImportDetails = dataImportDetails = reader.readArray(reader1 -> DataImportDetails.fromJson(reader1));
                    continue;
                }
                if ("model".equals(fieldName)) {
                    deserializedDataTransferDetailsValidationRequest.model = ModelName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataTransferDetailsValidationRequest;
        });
    }
}

