/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.DataAccountDetails;
import com.azure.resourcemanager.databox.models.LogCollectionLevel;
import java.io.IOException;

public final class DataImportDetails
implements JsonSerializable<DataImportDetails> {
    private DataAccountDetails accountDetails;
    private LogCollectionLevel logCollectionLevel;
    private static final ClientLogger LOGGER = new ClientLogger(DataImportDetails.class);

    public DataAccountDetails accountDetails() {
        return this.accountDetails;
    }

    public DataImportDetails withAccountDetails(DataAccountDetails accountDetails) {
        this.accountDetails = accountDetails;
        return this;
    }

    public LogCollectionLevel logCollectionLevel() {
        return this.logCollectionLevel;
    }

    public DataImportDetails withLogCollectionLevel(LogCollectionLevel logCollectionLevel) {
        this.logCollectionLevel = logCollectionLevel;
        return this;
    }

    public void validate() {
        if (this.accountDetails() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property accountDetails in model DataImportDetails"));
        }
        this.accountDetails().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("accountDetails", (JsonSerializable)this.accountDetails);
        jsonWriter.writeStringField("logCollectionLevel", this.logCollectionLevel == null ? null : this.logCollectionLevel.toString());
        return jsonWriter.writeEndObject();
    }

    public static DataImportDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DataImportDetails)jsonReader.readObject(reader -> {
            DataImportDetails deserializedDataImportDetails = new DataImportDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accountDetails".equals(fieldName)) {
                    deserializedDataImportDetails.accountDetails = DataAccountDetails.fromJson(reader);
                    continue;
                }
                if ("logCollectionLevel".equals(fieldName)) {
                    deserializedDataImportDetails.logCollectionLevel = LogCollectionLevel.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataImportDetails;
        });
    }
}

