/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.DataAccountDetails;
import com.azure.resourcemanager.databox.models.LogCollectionLevel;
import com.azure.resourcemanager.databox.models.TransferConfiguration;
import java.io.IOException;

public final class DataExportDetails
implements JsonSerializable<DataExportDetails> {
    private TransferConfiguration transferConfiguration;
    private LogCollectionLevel logCollectionLevel;
    private DataAccountDetails accountDetails;
    private static final ClientLogger LOGGER = new ClientLogger(DataExportDetails.class);

    public TransferConfiguration transferConfiguration() {
        return this.transferConfiguration;
    }

    public DataExportDetails withTransferConfiguration(TransferConfiguration transferConfiguration) {
        this.transferConfiguration = transferConfiguration;
        return this;
    }

    public LogCollectionLevel logCollectionLevel() {
        return this.logCollectionLevel;
    }

    public DataExportDetails withLogCollectionLevel(LogCollectionLevel logCollectionLevel) {
        this.logCollectionLevel = logCollectionLevel;
        return this;
    }

    public DataAccountDetails accountDetails() {
        return this.accountDetails;
    }

    public DataExportDetails withAccountDetails(DataAccountDetails accountDetails) {
        this.accountDetails = accountDetails;
        return this;
    }

    public void validate() {
        if (this.transferConfiguration() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property transferConfiguration in model DataExportDetails"));
        }
        this.transferConfiguration().validate();
        if (this.accountDetails() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property accountDetails in model DataExportDetails"));
        }
        this.accountDetails().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("transferConfiguration", (JsonSerializable)this.transferConfiguration);
        jsonWriter.writeJsonField("accountDetails", (JsonSerializable)this.accountDetails);
        jsonWriter.writeStringField("logCollectionLevel", this.logCollectionLevel == null ? null : this.logCollectionLevel.toString());
        return jsonWriter.writeEndObject();
    }

    public static DataExportDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DataExportDetails)jsonReader.readObject(reader -> {
            DataExportDetails deserializedDataExportDetails = new DataExportDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("transferConfiguration".equals(fieldName)) {
                    deserializedDataExportDetails.transferConfiguration = TransferConfiguration.fromJson(reader);
                    continue;
                }
                if ("accountDetails".equals(fieldName)) {
                    deserializedDataExportDetails.accountDetails = DataAccountDetails.fromJson(reader);
                    continue;
                }
                if ("logCollectionLevel".equals(fieldName)) {
                    deserializedDataExportDetails.logCollectionLevel = LogCollectionLevel.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataExportDetails;
        });
    }
}

