/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ModelName;
import com.azure.resourcemanager.databox.models.ScheduleAvailabilityRequest;
import com.azure.resourcemanager.databox.models.SkuName;
import java.io.IOException;

public final class DataBoxScheduleAvailabilityRequest
extends ScheduleAvailabilityRequest {
    private SkuName skuName = SkuName.DATA_BOX;
    private static final ClientLogger LOGGER = new ClientLogger(DataBoxScheduleAvailabilityRequest.class);

    @Override
    public SkuName skuName() {
        return this.skuName;
    }

    @Override
    public DataBoxScheduleAvailabilityRequest withStorageLocation(String storageLocation) {
        super.withStorageLocation(storageLocation);
        return this;
    }

    @Override
    public DataBoxScheduleAvailabilityRequest withCountry(String country) {
        super.withCountry(country);
        return this;
    }

    @Override
    public DataBoxScheduleAvailabilityRequest withModel(ModelName model) {
        super.withModel(model);
        return this;
    }

    @Override
    public void validate() {
        if (this.storageLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageLocation in model DataBoxScheduleAvailabilityRequest"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageLocation", this.storageLocation());
        jsonWriter.writeStringField("country", this.country());
        jsonWriter.writeStringField("model", this.model() == null ? null : this.model().toString());
        jsonWriter.writeStringField("skuName", this.skuName == null ? null : this.skuName.toString());
        return jsonWriter.writeEndObject();
    }

    public static DataBoxScheduleAvailabilityRequest fromJson(JsonReader jsonReader) throws IOException {
        return (DataBoxScheduleAvailabilityRequest)jsonReader.readObject(reader -> {
            DataBoxScheduleAvailabilityRequest deserializedDataBoxScheduleAvailabilityRequest = new DataBoxScheduleAvailabilityRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageLocation".equals(fieldName)) {
                    deserializedDataBoxScheduleAvailabilityRequest.withStorageLocation(reader.getString());
                    continue;
                }
                if ("country".equals(fieldName)) {
                    deserializedDataBoxScheduleAvailabilityRequest.withCountry(reader.getString());
                    continue;
                }
                if ("model".equals(fieldName)) {
                    deserializedDataBoxScheduleAvailabilityRequest.withModel(ModelName.fromString(reader.getString()));
                    continue;
                }
                if ("skuName".equals(fieldName)) {
                    deserializedDataBoxScheduleAvailabilityRequest.skuName = SkuName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataBoxScheduleAvailabilityRequest;
        });
    }
}

