/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ClassDiscriminator;
import com.azure.resourcemanager.databox.models.ContactDetails;
import com.azure.resourcemanager.databox.models.CopyLogDetails;
import com.azure.resourcemanager.databox.models.CopyProgress;
import com.azure.resourcemanager.databox.models.CustomerResolutionCode;
import com.azure.resourcemanager.databox.models.DataCenterCode;
import com.azure.resourcemanager.databox.models.DataExportDetails;
import com.azure.resourcemanager.databox.models.DataImportDetails;
import com.azure.resourcemanager.databox.models.DatacenterAddressResponse;
import com.azure.resourcemanager.databox.models.DeviceErasureDetails;
import com.azure.resourcemanager.databox.models.JobDetails;
import com.azure.resourcemanager.databox.models.JobStages;
import com.azure.resourcemanager.databox.models.KeyEncryptionKey;
import com.azure.resourcemanager.databox.models.LastMitigationActionOnJob;
import com.azure.resourcemanager.databox.models.PackageShippingDetails;
import com.azure.resourcemanager.databox.models.Preferences;
import com.azure.resourcemanager.databox.models.ReverseShippingDetails;
import com.azure.resourcemanager.databox.models.ShippingAddress;
import java.io.IOException;
import java.util.List;

public final class DataBoxJobDetails
extends JobDetails {
    private ClassDiscriminator jobDetailsType = ClassDiscriminator.DATA_BOX;
    private List<CopyProgress> copyProgress;
    private String devicePassword;
    private static final ClientLogger LOGGER = new ClientLogger(DataBoxJobDetails.class);

    @Override
    public ClassDiscriminator jobDetailsType() {
        return this.jobDetailsType;
    }

    public List<CopyProgress> copyProgress() {
        return this.copyProgress;
    }

    public String devicePassword() {
        return this.devicePassword;
    }

    public DataBoxJobDetails withDevicePassword(String devicePassword) {
        this.devicePassword = devicePassword;
        return this;
    }

    @Override
    public DataBoxJobDetails withContactDetails(ContactDetails contactDetails) {
        super.withContactDetails(contactDetails);
        return this;
    }

    @Override
    public DataBoxJobDetails withShippingAddress(ShippingAddress shippingAddress) {
        super.withShippingAddress(shippingAddress);
        return this;
    }

    @Override
    public DataBoxJobDetails withDataImportDetails(List<DataImportDetails> dataImportDetails) {
        super.withDataImportDetails(dataImportDetails);
        return this;
    }

    @Override
    public DataBoxJobDetails withDataExportDetails(List<DataExportDetails> dataExportDetails) {
        super.withDataExportDetails(dataExportDetails);
        return this;
    }

    @Override
    public DataBoxJobDetails withPreferences(Preferences preferences) {
        super.withPreferences(preferences);
        return this;
    }

    @Override
    public DataBoxJobDetails withReverseShippingDetails(ReverseShippingDetails reverseShippingDetails) {
        super.withReverseShippingDetails(reverseShippingDetails);
        return this;
    }

    @Override
    public DataBoxJobDetails withKeyEncryptionKey(KeyEncryptionKey keyEncryptionKey) {
        super.withKeyEncryptionKey(keyEncryptionKey);
        return this;
    }

    @Override
    public DataBoxJobDetails withExpectedDataSizeInTeraBytes(Integer expectedDataSizeInTeraBytes) {
        super.withExpectedDataSizeInTeraBytes(expectedDataSizeInTeraBytes);
        return this;
    }

    @Override
    public void validate() {
        if (this.copyProgress() != null) {
            this.copyProgress().forEach(e -> e.validate());
        }
        if (this.jobStages() != null) {
            this.jobStages().forEach(e -> e.validate());
        }
        if (this.contactDetails() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property contactDetails in model DataBoxJobDetails"));
        }
        this.contactDetails().validate();
        if (this.shippingAddress() != null) {
            this.shippingAddress().validate();
        }
        if (this.deliveryPackage() != null) {
            this.deliveryPackage().validate();
        }
        if (this.returnPackage() != null) {
            this.returnPackage().validate();
        }
        if (this.dataImportDetails() != null) {
            this.dataImportDetails().forEach(e -> e.validate());
        }
        if (this.dataExportDetails() != null) {
            this.dataExportDetails().forEach(e -> e.validate());
        }
        if (this.preferences() != null) {
            this.preferences().validate();
        }
        if (this.reverseShippingDetails() != null) {
            this.reverseShippingDetails().validate();
        }
        if (this.copyLogDetails() != null) {
            this.copyLogDetails().forEach(e -> e.validate());
        }
        if (this.deviceErasureDetails() != null) {
            this.deviceErasureDetails().validate();
        }
        if (this.keyEncryptionKey() != null) {
            this.keyEncryptionKey().validate();
        }
        if (this.lastMitigationActionOnJob() != null) {
            this.lastMitigationActionOnJob().validate();
        }
        if (this.datacenterAddress() != null) {
            this.datacenterAddress().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("contactDetails", (JsonSerializable)this.contactDetails());
        jsonWriter.writeJsonField("shippingAddress", (JsonSerializable)this.shippingAddress());
        jsonWriter.writeArrayField("dataImportDetails", this.dataImportDetails(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("dataExportDetails", this.dataExportDetails(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("preferences", (JsonSerializable)this.preferences());
        jsonWriter.writeJsonField("reverseShippingDetails", (JsonSerializable)this.reverseShippingDetails());
        jsonWriter.writeJsonField("keyEncryptionKey", (JsonSerializable)this.keyEncryptionKey());
        jsonWriter.writeNumberField("expectedDataSizeInTeraBytes", (Number)this.expectedDataSizeInTeraBytes());
        jsonWriter.writeStringField("jobDetailsType", this.jobDetailsType == null ? null : this.jobDetailsType.toString());
        jsonWriter.writeStringField("devicePassword", this.devicePassword);
        return jsonWriter.writeEndObject();
    }

    public static DataBoxJobDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DataBoxJobDetails)jsonReader.readObject(reader -> {
            DataBoxJobDetails deserializedDataBoxJobDetails = new DataBoxJobDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contactDetails".equals(fieldName)) {
                    deserializedDataBoxJobDetails.withContactDetails(ContactDetails.fromJson(reader));
                    continue;
                }
                if ("jobStages".equals(fieldName)) {
                    List jobStages = reader.readArray(reader1 -> JobStages.fromJson(reader1));
                    deserializedDataBoxJobDetails.withJobStages(jobStages);
                    continue;
                }
                if ("shippingAddress".equals(fieldName)) {
                    deserializedDataBoxJobDetails.withShippingAddress(ShippingAddress.fromJson(reader));
                    continue;
                }
                if ("deliveryPackage".equals(fieldName)) {
                    deserializedDataBoxJobDetails.withDeliveryPackage(PackageShippingDetails.fromJson(reader));
                    continue;
                }
                if ("returnPackage".equals(fieldName)) {
                    deserializedDataBoxJobDetails.withReturnPackage(PackageShippingDetails.fromJson(reader));
                    continue;
                }
                if ("dataImportDetails".equals(fieldName)) {
                    List dataImportDetails = reader.readArray(reader1 -> DataImportDetails.fromJson(reader1));
                    deserializedDataBoxJobDetails.withDataImportDetails(dataImportDetails);
                    continue;
                }
                if ("dataExportDetails".equals(fieldName)) {
                    List dataExportDetails = reader.readArray(reader1 -> DataExportDetails.fromJson(reader1));
                    deserializedDataBoxJobDetails.withDataExportDetails(dataExportDetails);
                    continue;
                }
                if ("preferences".equals(fieldName)) {
                    deserializedDataBoxJobDetails.withPreferences(Preferences.fromJson(reader));
                    continue;
                }
                if ("reverseShippingDetails".equals(fieldName)) {
                    deserializedDataBoxJobDetails.withReverseShippingDetails(ReverseShippingDetails.fromJson(reader));
                    continue;
                }
                if ("copyLogDetails".equals(fieldName)) {
                    List copyLogDetails = reader.readArray(reader1 -> CopyLogDetails.fromJson(reader1));
                    deserializedDataBoxJobDetails.withCopyLogDetails(copyLogDetails);
                    continue;
                }
                if ("reverseShipmentLabelSasKey".equals(fieldName)) {
                    deserializedDataBoxJobDetails.withReverseShipmentLabelSasKey(reader.getString());
                    continue;
                }
                if ("chainOfCustodySasKey".equals(fieldName)) {
                    deserializedDataBoxJobDetails.withChainOfCustodySasKey(reader.getString());
                    continue;
                }
                if ("deviceErasureDetails".equals(fieldName)) {
                    deserializedDataBoxJobDetails.withDeviceErasureDetails(DeviceErasureDetails.fromJson(reader));
                    continue;
                }
                if ("keyEncryptionKey".equals(fieldName)) {
                    deserializedDataBoxJobDetails.withKeyEncryptionKey(KeyEncryptionKey.fromJson(reader));
                    continue;
                }
                if ("expectedDataSizeInTeraBytes".equals(fieldName)) {
                    deserializedDataBoxJobDetails.withExpectedDataSizeInTeraBytes((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List actions = reader.readArray(reader1 -> CustomerResolutionCode.fromString(reader1.getString()));
                    deserializedDataBoxJobDetails.withActions(actions);
                    continue;
                }
                if ("lastMitigationActionOnJob".equals(fieldName)) {
                    deserializedDataBoxJobDetails.withLastMitigationActionOnJob(LastMitigationActionOnJob.fromJson(reader));
                    continue;
                }
                if ("datacenterAddress".equals(fieldName)) {
                    deserializedDataBoxJobDetails.withDatacenterAddress(DatacenterAddressResponse.fromJson(reader));
                    continue;
                }
                if ("dataCenterCode".equals(fieldName)) {
                    deserializedDataBoxJobDetails.withDataCenterCode(DataCenterCode.fromString(reader.getString()));
                    continue;
                }
                if ("jobDetailsType".equals(fieldName)) {
                    deserializedDataBoxJobDetails.jobDetailsType = ClassDiscriminator.fromString(reader.getString());
                    continue;
                }
                if ("copyProgress".equals(fieldName)) {
                    List copyProgress;
                    deserializedDataBoxJobDetails.copyProgress = copyProgress = reader.readArray(reader1 -> CopyProgress.fromJson(reader1));
                    continue;
                }
                if ("devicePassword".equals(fieldName)) {
                    deserializedDataBoxJobDetails.devicePassword = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataBoxJobDetails;
        });
    }
}

