/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.AccountCredentialDetails;
import com.azure.resourcemanager.databox.models.ApplianceNetworkConfiguration;
import java.io.IOException;
import java.util.List;

public final class DataBoxHeavySecret
implements JsonSerializable<DataBoxHeavySecret> {
    private String deviceSerialNumber;
    private String devicePassword;
    private List<ApplianceNetworkConfiguration> networkConfigurations;
    private String encodedValidationCertPubKey;
    private List<AccountCredentialDetails> accountCredentialDetails;

    public String deviceSerialNumber() {
        return this.deviceSerialNumber;
    }

    public String devicePassword() {
        return this.devicePassword;
    }

    public List<ApplianceNetworkConfiguration> networkConfigurations() {
        return this.networkConfigurations;
    }

    public String encodedValidationCertPubKey() {
        return this.encodedValidationCertPubKey;
    }

    public List<AccountCredentialDetails> accountCredentialDetails() {
        return this.accountCredentialDetails;
    }

    public void validate() {
        if (this.networkConfigurations() != null) {
            this.networkConfigurations().forEach(e -> e.validate());
        }
        if (this.accountCredentialDetails() != null) {
            this.accountCredentialDetails().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static DataBoxHeavySecret fromJson(JsonReader jsonReader) throws IOException {
        return (DataBoxHeavySecret)jsonReader.readObject(reader -> {
            DataBoxHeavySecret deserializedDataBoxHeavySecret = new DataBoxHeavySecret();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deviceSerialNumber".equals(fieldName)) {
                    deserializedDataBoxHeavySecret.deviceSerialNumber = reader.getString();
                    continue;
                }
                if ("devicePassword".equals(fieldName)) {
                    deserializedDataBoxHeavySecret.devicePassword = reader.getString();
                    continue;
                }
                if ("networkConfigurations".equals(fieldName)) {
                    List networkConfigurations;
                    deserializedDataBoxHeavySecret.networkConfigurations = networkConfigurations = reader.readArray(reader1 -> ApplianceNetworkConfiguration.fromJson(reader1));
                    continue;
                }
                if ("encodedValidationCertPubKey".equals(fieldName)) {
                    deserializedDataBoxHeavySecret.encodedValidationCertPubKey = reader.getString();
                    continue;
                }
                if ("accountCredentialDetails".equals(fieldName)) {
                    List accountCredentialDetails;
                    deserializedDataBoxHeavySecret.accountCredentialDetails = accountCredentialDetails = reader.readArray(reader1 -> AccountCredentialDetails.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataBoxHeavySecret;
        });
    }
}

