/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ClassDiscriminator;
import com.azure.resourcemanager.databox.models.CloudError;
import com.azure.resourcemanager.databox.models.DataBoxHeavySecret;
import com.azure.resourcemanager.databox.models.DcAccessSecurityCode;
import com.azure.resourcemanager.databox.models.JobSecrets;
import java.io.IOException;
import java.util.List;

public final class DataBoxHeavyJobSecrets
extends JobSecrets {
    private ClassDiscriminator jobSecretsType = ClassDiscriminator.DATA_BOX_HEAVY;
    private List<DataBoxHeavySecret> cabinetPodSecrets;

    @Override
    public ClassDiscriminator jobSecretsType() {
        return this.jobSecretsType;
    }

    public List<DataBoxHeavySecret> cabinetPodSecrets() {
        return this.cabinetPodSecrets;
    }

    @Override
    public void validate() {
        if (this.cabinetPodSecrets() != null) {
            this.cabinetPodSecrets().forEach(e -> e.validate());
        }
        if (this.dcAccessSecurityCode() != null) {
            this.dcAccessSecurityCode().validate();
        }
        if (this.error() != null) {
            this.error().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("jobSecretsType", this.jobSecretsType == null ? null : this.jobSecretsType.toString());
        return jsonWriter.writeEndObject();
    }

    public static DataBoxHeavyJobSecrets fromJson(JsonReader jsonReader) throws IOException {
        return (DataBoxHeavyJobSecrets)jsonReader.readObject(reader -> {
            DataBoxHeavyJobSecrets deserializedDataBoxHeavyJobSecrets = new DataBoxHeavyJobSecrets();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dcAccessSecurityCode".equals(fieldName)) {
                    deserializedDataBoxHeavyJobSecrets.withDcAccessSecurityCode(DcAccessSecurityCode.fromJson(reader));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedDataBoxHeavyJobSecrets.withError(CloudError.fromJson(reader));
                    continue;
                }
                if ("jobSecretsType".equals(fieldName)) {
                    deserializedDataBoxHeavyJobSecrets.jobSecretsType = ClassDiscriminator.fromString(reader.getString());
                    continue;
                }
                if ("cabinetPodSecrets".equals(fieldName)) {
                    List cabinetPodSecrets;
                    deserializedDataBoxHeavyJobSecrets.cabinetPodSecrets = cabinetPodSecrets = reader.readArray(reader1 -> DataBoxHeavySecret.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataBoxHeavyJobSecrets;
        });
    }
}

