/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ClassDiscriminator;
import com.azure.resourcemanager.databox.models.ContactDetails;
import com.azure.resourcemanager.databox.models.CopyLogDetails;
import com.azure.resourcemanager.databox.models.CopyProgress;
import com.azure.resourcemanager.databox.models.CustomerResolutionCode;
import com.azure.resourcemanager.databox.models.DataCenterCode;
import com.azure.resourcemanager.databox.models.DataExportDetails;
import com.azure.resourcemanager.databox.models.DataImportDetails;
import com.azure.resourcemanager.databox.models.DatacenterAddressResponse;
import com.azure.resourcemanager.databox.models.DeviceErasureDetails;
import com.azure.resourcemanager.databox.models.JobDetails;
import com.azure.resourcemanager.databox.models.JobStages;
import com.azure.resourcemanager.databox.models.KeyEncryptionKey;
import com.azure.resourcemanager.databox.models.LastMitigationActionOnJob;
import com.azure.resourcemanager.databox.models.PackageShippingDetails;
import com.azure.resourcemanager.databox.models.Preferences;
import com.azure.resourcemanager.databox.models.ReverseShippingDetails;
import com.azure.resourcemanager.databox.models.ShippingAddress;
import java.io.IOException;
import java.util.List;

public final class DataBoxHeavyJobDetails
extends JobDetails {
    private ClassDiscriminator jobDetailsType = ClassDiscriminator.DATA_BOX_HEAVY;
    private List<CopyProgress> copyProgress;
    private String devicePassword;
    private static final ClientLogger LOGGER = new ClientLogger(DataBoxHeavyJobDetails.class);

    @Override
    public ClassDiscriminator jobDetailsType() {
        return this.jobDetailsType;
    }

    public List<CopyProgress> copyProgress() {
        return this.copyProgress;
    }

    public String devicePassword() {
        return this.devicePassword;
    }

    public DataBoxHeavyJobDetails withDevicePassword(String devicePassword) {
        this.devicePassword = devicePassword;
        return this;
    }

    @Override
    public DataBoxHeavyJobDetails withContactDetails(ContactDetails contactDetails) {
        super.withContactDetails(contactDetails);
        return this;
    }

    @Override
    public DataBoxHeavyJobDetails withShippingAddress(ShippingAddress shippingAddress) {
        super.withShippingAddress(shippingAddress);
        return this;
    }

    @Override
    public DataBoxHeavyJobDetails withDataImportDetails(List<DataImportDetails> dataImportDetails) {
        super.withDataImportDetails(dataImportDetails);
        return this;
    }

    @Override
    public DataBoxHeavyJobDetails withDataExportDetails(List<DataExportDetails> dataExportDetails) {
        super.withDataExportDetails(dataExportDetails);
        return this;
    }

    @Override
    public DataBoxHeavyJobDetails withPreferences(Preferences preferences) {
        super.withPreferences(preferences);
        return this;
    }

    @Override
    public DataBoxHeavyJobDetails withReverseShippingDetails(ReverseShippingDetails reverseShippingDetails) {
        super.withReverseShippingDetails(reverseShippingDetails);
        return this;
    }

    @Override
    public DataBoxHeavyJobDetails withKeyEncryptionKey(KeyEncryptionKey keyEncryptionKey) {
        super.withKeyEncryptionKey(keyEncryptionKey);
        return this;
    }

    @Override
    public DataBoxHeavyJobDetails withExpectedDataSizeInTeraBytes(Integer expectedDataSizeInTeraBytes) {
        super.withExpectedDataSizeInTeraBytes(expectedDataSizeInTeraBytes);
        return this;
    }

    @Override
    public void validate() {
        if (this.copyProgress() != null) {
            this.copyProgress().forEach(e -> e.validate());
        }
        if (this.jobStages() != null) {
            this.jobStages().forEach(e -> e.validate());
        }
        if (this.contactDetails() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property contactDetails in model DataBoxHeavyJobDetails"));
        }
        this.contactDetails().validate();
        if (this.shippingAddress() != null) {
            this.shippingAddress().validate();
        }
        if (this.deliveryPackage() != null) {
            this.deliveryPackage().validate();
        }
        if (this.returnPackage() != null) {
            this.returnPackage().validate();
        }
        if (this.dataImportDetails() != null) {
            this.dataImportDetails().forEach(e -> e.validate());
        }
        if (this.dataExportDetails() != null) {
            this.dataExportDetails().forEach(e -> e.validate());
        }
        if (this.preferences() != null) {
            this.preferences().validate();
        }
        if (this.reverseShippingDetails() != null) {
            this.reverseShippingDetails().validate();
        }
        if (this.copyLogDetails() != null) {
            this.copyLogDetails().forEach(e -> e.validate());
        }
        if (this.deviceErasureDetails() != null) {
            this.deviceErasureDetails().validate();
        }
        if (this.keyEncryptionKey() != null) {
            this.keyEncryptionKey().validate();
        }
        if (this.lastMitigationActionOnJob() != null) {
            this.lastMitigationActionOnJob().validate();
        }
        if (this.datacenterAddress() != null) {
            this.datacenterAddress().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("contactDetails", (JsonSerializable)this.contactDetails());
        jsonWriter.writeJsonField("shippingAddress", (JsonSerializable)this.shippingAddress());
        jsonWriter.writeArrayField("dataImportDetails", this.dataImportDetails(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("dataExportDetails", this.dataExportDetails(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("preferences", (JsonSerializable)this.preferences());
        jsonWriter.writeJsonField("reverseShippingDetails", (JsonSerializable)this.reverseShippingDetails());
        jsonWriter.writeJsonField("keyEncryptionKey", (JsonSerializable)this.keyEncryptionKey());
        jsonWriter.writeNumberField("expectedDataSizeInTeraBytes", (Number)this.expectedDataSizeInTeraBytes());
        jsonWriter.writeStringField("jobDetailsType", this.jobDetailsType == null ? null : this.jobDetailsType.toString());
        jsonWriter.writeStringField("devicePassword", this.devicePassword);
        return jsonWriter.writeEndObject();
    }

    public static DataBoxHeavyJobDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DataBoxHeavyJobDetails)jsonReader.readObject(reader -> {
            DataBoxHeavyJobDetails deserializedDataBoxHeavyJobDetails = new DataBoxHeavyJobDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contactDetails".equals(fieldName)) {
                    deserializedDataBoxHeavyJobDetails.withContactDetails(ContactDetails.fromJson(reader));
                    continue;
                }
                if ("jobStages".equals(fieldName)) {
                    List jobStages = reader.readArray(reader1 -> JobStages.fromJson(reader1));
                    deserializedDataBoxHeavyJobDetails.withJobStages(jobStages);
                    continue;
                }
                if ("shippingAddress".equals(fieldName)) {
                    deserializedDataBoxHeavyJobDetails.withShippingAddress(ShippingAddress.fromJson(reader));
                    continue;
                }
                if ("deliveryPackage".equals(fieldName)) {
                    deserializedDataBoxHeavyJobDetails.withDeliveryPackage(PackageShippingDetails.fromJson(reader));
                    continue;
                }
                if ("returnPackage".equals(fieldName)) {
                    deserializedDataBoxHeavyJobDetails.withReturnPackage(PackageShippingDetails.fromJson(reader));
                    continue;
                }
                if ("dataImportDetails".equals(fieldName)) {
                    List dataImportDetails = reader.readArray(reader1 -> DataImportDetails.fromJson(reader1));
                    deserializedDataBoxHeavyJobDetails.withDataImportDetails(dataImportDetails);
                    continue;
                }
                if ("dataExportDetails".equals(fieldName)) {
                    List dataExportDetails = reader.readArray(reader1 -> DataExportDetails.fromJson(reader1));
                    deserializedDataBoxHeavyJobDetails.withDataExportDetails(dataExportDetails);
                    continue;
                }
                if ("preferences".equals(fieldName)) {
                    deserializedDataBoxHeavyJobDetails.withPreferences(Preferences.fromJson(reader));
                    continue;
                }
                if ("reverseShippingDetails".equals(fieldName)) {
                    deserializedDataBoxHeavyJobDetails.withReverseShippingDetails(ReverseShippingDetails.fromJson(reader));
                    continue;
                }
                if ("copyLogDetails".equals(fieldName)) {
                    List copyLogDetails = reader.readArray(reader1 -> CopyLogDetails.fromJson(reader1));
                    deserializedDataBoxHeavyJobDetails.withCopyLogDetails(copyLogDetails);
                    continue;
                }
                if ("reverseShipmentLabelSasKey".equals(fieldName)) {
                    deserializedDataBoxHeavyJobDetails.withReverseShipmentLabelSasKey(reader.getString());
                    continue;
                }
                if ("chainOfCustodySasKey".equals(fieldName)) {
                    deserializedDataBoxHeavyJobDetails.withChainOfCustodySasKey(reader.getString());
                    continue;
                }
                if ("deviceErasureDetails".equals(fieldName)) {
                    deserializedDataBoxHeavyJobDetails.withDeviceErasureDetails(DeviceErasureDetails.fromJson(reader));
                    continue;
                }
                if ("keyEncryptionKey".equals(fieldName)) {
                    deserializedDataBoxHeavyJobDetails.withKeyEncryptionKey(KeyEncryptionKey.fromJson(reader));
                    continue;
                }
                if ("expectedDataSizeInTeraBytes".equals(fieldName)) {
                    deserializedDataBoxHeavyJobDetails.withExpectedDataSizeInTeraBytes((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List actions = reader.readArray(reader1 -> CustomerResolutionCode.fromString(reader1.getString()));
                    deserializedDataBoxHeavyJobDetails.withActions(actions);
                    continue;
                }
                if ("lastMitigationActionOnJob".equals(fieldName)) {
                    deserializedDataBoxHeavyJobDetails.withLastMitigationActionOnJob(LastMitigationActionOnJob.fromJson(reader));
                    continue;
                }
                if ("datacenterAddress".equals(fieldName)) {
                    deserializedDataBoxHeavyJobDetails.withDatacenterAddress(DatacenterAddressResponse.fromJson(reader));
                    continue;
                }
                if ("dataCenterCode".equals(fieldName)) {
                    deserializedDataBoxHeavyJobDetails.withDataCenterCode(DataCenterCode.fromString(reader.getString()));
                    continue;
                }
                if ("jobDetailsType".equals(fieldName)) {
                    deserializedDataBoxHeavyJobDetails.jobDetailsType = ClassDiscriminator.fromString(reader.getString());
                    continue;
                }
                if ("copyProgress".equals(fieldName)) {
                    List copyProgress;
                    deserializedDataBoxHeavyJobDetails.copyProgress = copyProgress = reader.readArray(reader1 -> CopyProgress.fromJson(reader1));
                    continue;
                }
                if ("devicePassword".equals(fieldName)) {
                    deserializedDataBoxHeavyJobDetails.devicePassword = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataBoxHeavyJobDetails;
        });
    }
}

