/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ClassDiscriminator;
import com.azure.resourcemanager.databox.models.CloudError;
import com.azure.resourcemanager.databox.models.DcAccessSecurityCode;
import com.azure.resourcemanager.databox.models.DiskSecret;
import com.azure.resourcemanager.databox.models.JobSecrets;
import java.io.IOException;
import java.util.List;

public final class DataBoxDiskJobSecrets
extends JobSecrets {
    private ClassDiscriminator jobSecretsType = ClassDiscriminator.DATA_BOX_DISK;
    private List<DiskSecret> diskSecrets;
    private String passKey;
    private Boolean isPasskeyUserDefined;

    @Override
    public ClassDiscriminator jobSecretsType() {
        return this.jobSecretsType;
    }

    public List<DiskSecret> diskSecrets() {
        return this.diskSecrets;
    }

    public String passKey() {
        return this.passKey;
    }

    public Boolean isPasskeyUserDefined() {
        return this.isPasskeyUserDefined;
    }

    @Override
    public void validate() {
        if (this.diskSecrets() != null) {
            this.diskSecrets().forEach(e -> e.validate());
        }
        if (this.dcAccessSecurityCode() != null) {
            this.dcAccessSecurityCode().validate();
        }
        if (this.error() != null) {
            this.error().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("jobSecretsType", this.jobSecretsType == null ? null : this.jobSecretsType.toString());
        return jsonWriter.writeEndObject();
    }

    public static DataBoxDiskJobSecrets fromJson(JsonReader jsonReader) throws IOException {
        return (DataBoxDiskJobSecrets)jsonReader.readObject(reader -> {
            DataBoxDiskJobSecrets deserializedDataBoxDiskJobSecrets = new DataBoxDiskJobSecrets();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dcAccessSecurityCode".equals(fieldName)) {
                    deserializedDataBoxDiskJobSecrets.withDcAccessSecurityCode(DcAccessSecurityCode.fromJson(reader));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedDataBoxDiskJobSecrets.withError(CloudError.fromJson(reader));
                    continue;
                }
                if ("jobSecretsType".equals(fieldName)) {
                    deserializedDataBoxDiskJobSecrets.jobSecretsType = ClassDiscriminator.fromString(reader.getString());
                    continue;
                }
                if ("diskSecrets".equals(fieldName)) {
                    List diskSecrets;
                    deserializedDataBoxDiskJobSecrets.diskSecrets = diskSecrets = reader.readArray(reader1 -> DiskSecret.fromJson(reader1));
                    continue;
                }
                if ("passKey".equals(fieldName)) {
                    deserializedDataBoxDiskJobSecrets.passKey = reader.getString();
                    continue;
                }
                if ("isPasskeyUserDefined".equals(fieldName)) {
                    deserializedDataBoxDiskJobSecrets.isPasskeyUserDefined = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataBoxDiskJobSecrets;
        });
    }
}

