/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ClassDiscriminator;
import com.azure.resourcemanager.databox.models.ContactDetails;
import com.azure.resourcemanager.databox.models.CopyLogDetails;
import com.azure.resourcemanager.databox.models.CustomerResolutionCode;
import com.azure.resourcemanager.databox.models.DataBoxDiskCopyProgress;
import com.azure.resourcemanager.databox.models.DataBoxDiskGranularCopyLogDetails;
import com.azure.resourcemanager.databox.models.DataBoxDiskGranularCopyProgress;
import com.azure.resourcemanager.databox.models.DataCenterCode;
import com.azure.resourcemanager.databox.models.DataExportDetails;
import com.azure.resourcemanager.databox.models.DataImportDetails;
import com.azure.resourcemanager.databox.models.DatacenterAddressResponse;
import com.azure.resourcemanager.databox.models.DeviceErasureDetails;
import com.azure.resourcemanager.databox.models.JobDetails;
import com.azure.resourcemanager.databox.models.JobStages;
import com.azure.resourcemanager.databox.models.KeyEncryptionKey;
import com.azure.resourcemanager.databox.models.LastMitigationActionOnJob;
import com.azure.resourcemanager.databox.models.PackageShippingDetails;
import com.azure.resourcemanager.databox.models.Preferences;
import com.azure.resourcemanager.databox.models.ReverseShippingDetails;
import com.azure.resourcemanager.databox.models.ShippingAddress;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DataBoxDiskJobDetails
extends JobDetails {
    private ClassDiscriminator jobDetailsType = ClassDiscriminator.DATA_BOX_DISK;
    private Map<String, Integer> preferredDisks;
    private List<DataBoxDiskCopyProgress> copyProgress;
    private List<DataBoxDiskGranularCopyProgress> granularCopyProgress;
    private List<DataBoxDiskGranularCopyLogDetails> granularCopyLogDetails;
    private Map<String, Integer> disksAndSizeDetails;
    private String passkey;
    private static final ClientLogger LOGGER = new ClientLogger(DataBoxDiskJobDetails.class);

    @Override
    public ClassDiscriminator jobDetailsType() {
        return this.jobDetailsType;
    }

    public Map<String, Integer> preferredDisks() {
        return this.preferredDisks;
    }

    public DataBoxDiskJobDetails withPreferredDisks(Map<String, Integer> preferredDisks) {
        this.preferredDisks = preferredDisks;
        return this;
    }

    public List<DataBoxDiskCopyProgress> copyProgress() {
        return this.copyProgress;
    }

    public List<DataBoxDiskGranularCopyProgress> granularCopyProgress() {
        return this.granularCopyProgress;
    }

    public List<DataBoxDiskGranularCopyLogDetails> granularCopyLogDetails() {
        return this.granularCopyLogDetails;
    }

    public Map<String, Integer> disksAndSizeDetails() {
        return this.disksAndSizeDetails;
    }

    public String passkey() {
        return this.passkey;
    }

    public DataBoxDiskJobDetails withPasskey(String passkey) {
        this.passkey = passkey;
        return this;
    }

    @Override
    public DataBoxDiskJobDetails withContactDetails(ContactDetails contactDetails) {
        super.withContactDetails(contactDetails);
        return this;
    }

    @Override
    public DataBoxDiskJobDetails withShippingAddress(ShippingAddress shippingAddress) {
        super.withShippingAddress(shippingAddress);
        return this;
    }

    @Override
    public DataBoxDiskJobDetails withDataImportDetails(List<DataImportDetails> dataImportDetails) {
        super.withDataImportDetails(dataImportDetails);
        return this;
    }

    @Override
    public DataBoxDiskJobDetails withDataExportDetails(List<DataExportDetails> dataExportDetails) {
        super.withDataExportDetails(dataExportDetails);
        return this;
    }

    @Override
    public DataBoxDiskJobDetails withPreferences(Preferences preferences) {
        super.withPreferences(preferences);
        return this;
    }

    @Override
    public DataBoxDiskJobDetails withReverseShippingDetails(ReverseShippingDetails reverseShippingDetails) {
        super.withReverseShippingDetails(reverseShippingDetails);
        return this;
    }

    @Override
    public DataBoxDiskJobDetails withKeyEncryptionKey(KeyEncryptionKey keyEncryptionKey) {
        super.withKeyEncryptionKey(keyEncryptionKey);
        return this;
    }

    @Override
    public DataBoxDiskJobDetails withExpectedDataSizeInTeraBytes(Integer expectedDataSizeInTeraBytes) {
        super.withExpectedDataSizeInTeraBytes(expectedDataSizeInTeraBytes);
        return this;
    }

    @Override
    public void validate() {
        if (this.copyProgress() != null) {
            this.copyProgress().forEach(e -> e.validate());
        }
        if (this.granularCopyProgress() != null) {
            this.granularCopyProgress().forEach(e -> e.validate());
        }
        if (this.granularCopyLogDetails() != null) {
            this.granularCopyLogDetails().forEach(e -> e.validate());
        }
        if (this.jobStages() != null) {
            this.jobStages().forEach(e -> e.validate());
        }
        if (this.contactDetails() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property contactDetails in model DataBoxDiskJobDetails"));
        }
        this.contactDetails().validate();
        if (this.shippingAddress() != null) {
            this.shippingAddress().validate();
        }
        if (this.deliveryPackage() != null) {
            this.deliveryPackage().validate();
        }
        if (this.returnPackage() != null) {
            this.returnPackage().validate();
        }
        if (this.dataImportDetails() != null) {
            this.dataImportDetails().forEach(e -> e.validate());
        }
        if (this.dataExportDetails() != null) {
            this.dataExportDetails().forEach(e -> e.validate());
        }
        if (this.preferences() != null) {
            this.preferences().validate();
        }
        if (this.reverseShippingDetails() != null) {
            this.reverseShippingDetails().validate();
        }
        if (this.copyLogDetails() != null) {
            this.copyLogDetails().forEach(e -> e.validate());
        }
        if (this.deviceErasureDetails() != null) {
            this.deviceErasureDetails().validate();
        }
        if (this.keyEncryptionKey() != null) {
            this.keyEncryptionKey().validate();
        }
        if (this.lastMitigationActionOnJob() != null) {
            this.lastMitigationActionOnJob().validate();
        }
        if (this.datacenterAddress() != null) {
            this.datacenterAddress().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("contactDetails", (JsonSerializable)this.contactDetails());
        jsonWriter.writeJsonField("shippingAddress", (JsonSerializable)this.shippingAddress());
        jsonWriter.writeArrayField("dataImportDetails", this.dataImportDetails(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("dataExportDetails", this.dataExportDetails(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("preferences", (JsonSerializable)this.preferences());
        jsonWriter.writeJsonField("reverseShippingDetails", (JsonSerializable)this.reverseShippingDetails());
        jsonWriter.writeJsonField("keyEncryptionKey", (JsonSerializable)this.keyEncryptionKey());
        jsonWriter.writeNumberField("expectedDataSizeInTeraBytes", (Number)this.expectedDataSizeInTeraBytes());
        jsonWriter.writeStringField("jobDetailsType", this.jobDetailsType == null ? null : this.jobDetailsType.toString());
        jsonWriter.writeMapField("preferredDisks", this.preferredDisks, (writer, element) -> writer.writeInt(element.intValue()));
        jsonWriter.writeStringField("passkey", this.passkey);
        return jsonWriter.writeEndObject();
    }

    public static DataBoxDiskJobDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DataBoxDiskJobDetails)jsonReader.readObject(reader -> {
            DataBoxDiskJobDetails deserializedDataBoxDiskJobDetails = new DataBoxDiskJobDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contactDetails".equals(fieldName)) {
                    deserializedDataBoxDiskJobDetails.withContactDetails(ContactDetails.fromJson(reader));
                    continue;
                }
                if ("jobStages".equals(fieldName)) {
                    List jobStages = reader.readArray(reader1 -> JobStages.fromJson(reader1));
                    deserializedDataBoxDiskJobDetails.withJobStages(jobStages);
                    continue;
                }
                if ("shippingAddress".equals(fieldName)) {
                    deserializedDataBoxDiskJobDetails.withShippingAddress(ShippingAddress.fromJson(reader));
                    continue;
                }
                if ("deliveryPackage".equals(fieldName)) {
                    deserializedDataBoxDiskJobDetails.withDeliveryPackage(PackageShippingDetails.fromJson(reader));
                    continue;
                }
                if ("returnPackage".equals(fieldName)) {
                    deserializedDataBoxDiskJobDetails.withReturnPackage(PackageShippingDetails.fromJson(reader));
                    continue;
                }
                if ("dataImportDetails".equals(fieldName)) {
                    List dataImportDetails = reader.readArray(reader1 -> DataImportDetails.fromJson(reader1));
                    deserializedDataBoxDiskJobDetails.withDataImportDetails(dataImportDetails);
                    continue;
                }
                if ("dataExportDetails".equals(fieldName)) {
                    List dataExportDetails = reader.readArray(reader1 -> DataExportDetails.fromJson(reader1));
                    deserializedDataBoxDiskJobDetails.withDataExportDetails(dataExportDetails);
                    continue;
                }
                if ("preferences".equals(fieldName)) {
                    deserializedDataBoxDiskJobDetails.withPreferences(Preferences.fromJson(reader));
                    continue;
                }
                if ("reverseShippingDetails".equals(fieldName)) {
                    deserializedDataBoxDiskJobDetails.withReverseShippingDetails(ReverseShippingDetails.fromJson(reader));
                    continue;
                }
                if ("copyLogDetails".equals(fieldName)) {
                    List copyLogDetails = reader.readArray(reader1 -> CopyLogDetails.fromJson(reader1));
                    deserializedDataBoxDiskJobDetails.withCopyLogDetails(copyLogDetails);
                    continue;
                }
                if ("reverseShipmentLabelSasKey".equals(fieldName)) {
                    deserializedDataBoxDiskJobDetails.withReverseShipmentLabelSasKey(reader.getString());
                    continue;
                }
                if ("chainOfCustodySasKey".equals(fieldName)) {
                    deserializedDataBoxDiskJobDetails.withChainOfCustodySasKey(reader.getString());
                    continue;
                }
                if ("deviceErasureDetails".equals(fieldName)) {
                    deserializedDataBoxDiskJobDetails.withDeviceErasureDetails(DeviceErasureDetails.fromJson(reader));
                    continue;
                }
                if ("keyEncryptionKey".equals(fieldName)) {
                    deserializedDataBoxDiskJobDetails.withKeyEncryptionKey(KeyEncryptionKey.fromJson(reader));
                    continue;
                }
                if ("expectedDataSizeInTeraBytes".equals(fieldName)) {
                    deserializedDataBoxDiskJobDetails.withExpectedDataSizeInTeraBytes((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List actions = reader.readArray(reader1 -> CustomerResolutionCode.fromString(reader1.getString()));
                    deserializedDataBoxDiskJobDetails.withActions(actions);
                    continue;
                }
                if ("lastMitigationActionOnJob".equals(fieldName)) {
                    deserializedDataBoxDiskJobDetails.withLastMitigationActionOnJob(LastMitigationActionOnJob.fromJson(reader));
                    continue;
                }
                if ("datacenterAddress".equals(fieldName)) {
                    deserializedDataBoxDiskJobDetails.withDatacenterAddress(DatacenterAddressResponse.fromJson(reader));
                    continue;
                }
                if ("dataCenterCode".equals(fieldName)) {
                    deserializedDataBoxDiskJobDetails.withDataCenterCode(DataCenterCode.fromString(reader.getString()));
                    continue;
                }
                if ("jobDetailsType".equals(fieldName)) {
                    deserializedDataBoxDiskJobDetails.jobDetailsType = ClassDiscriminator.fromString(reader.getString());
                    continue;
                }
                if ("preferredDisks".equals(fieldName)) {
                    Map preferredDisks;
                    deserializedDataBoxDiskJobDetails.preferredDisks = preferredDisks = reader.readMap(reader1 -> reader1.getInt());
                    continue;
                }
                if ("copyProgress".equals(fieldName)) {
                    List copyProgress;
                    deserializedDataBoxDiskJobDetails.copyProgress = copyProgress = reader.readArray(reader1 -> DataBoxDiskCopyProgress.fromJson(reader1));
                    continue;
                }
                if ("granularCopyProgress".equals(fieldName)) {
                    List granularCopyProgress;
                    deserializedDataBoxDiskJobDetails.granularCopyProgress = granularCopyProgress = reader.readArray(reader1 -> DataBoxDiskGranularCopyProgress.fromJson(reader1));
                    continue;
                }
                if ("granularCopyLogDetails".equals(fieldName)) {
                    List granularCopyLogDetails;
                    deserializedDataBoxDiskJobDetails.granularCopyLogDetails = granularCopyLogDetails = reader.readArray(reader1 -> DataBoxDiskGranularCopyLogDetails.fromJson(reader1));
                    continue;
                }
                if ("disksAndSizeDetails".equals(fieldName)) {
                    Map disksAndSizeDetails;
                    deserializedDataBoxDiskJobDetails.disksAndSizeDetails = disksAndSizeDetails = reader.readMap(reader1 -> reader1.getInt());
                    continue;
                }
                if ("passkey".equals(fieldName)) {
                    deserializedDataBoxDiskJobDetails.passkey = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataBoxDiskJobDetails;
        });
    }
}

