/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.CloudError;
import com.azure.resourcemanager.databox.models.CopyStatus;
import com.azure.resourcemanager.databox.models.CustomerResolutionCode;
import java.io.IOException;
import java.util.List;

public final class DataBoxDiskCopyProgress
implements JsonSerializable<DataBoxDiskCopyProgress> {
    private String serialNumber;
    private Long bytesCopied;
    private Integer percentComplete;
    private CopyStatus status;
    private CloudError error;
    private List<CustomerResolutionCode> actions;

    public String serialNumber() {
        return this.serialNumber;
    }

    public Long bytesCopied() {
        return this.bytesCopied;
    }

    public Integer percentComplete() {
        return this.percentComplete;
    }

    public CopyStatus status() {
        return this.status;
    }

    public CloudError error() {
        return this.error;
    }

    public List<CustomerResolutionCode> actions() {
        return this.actions;
    }

    public void validate() {
        if (this.error() != null) {
            this.error().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static DataBoxDiskCopyProgress fromJson(JsonReader jsonReader) throws IOException {
        return (DataBoxDiskCopyProgress)jsonReader.readObject(reader -> {
            DataBoxDiskCopyProgress deserializedDataBoxDiskCopyProgress = new DataBoxDiskCopyProgress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serialNumber".equals(fieldName)) {
                    deserializedDataBoxDiskCopyProgress.serialNumber = reader.getString();
                    continue;
                }
                if ("bytesCopied".equals(fieldName)) {
                    deserializedDataBoxDiskCopyProgress.bytesCopied = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("percentComplete".equals(fieldName)) {
                    deserializedDataBoxDiskCopyProgress.percentComplete = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedDataBoxDiskCopyProgress.status = CopyStatus.fromString(reader.getString());
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedDataBoxDiskCopyProgress.error = CloudError.fromJson(reader);
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List actions;
                    deserializedDataBoxDiskCopyProgress.actions = actions = reader.readArray(reader1 -> CustomerResolutionCode.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataBoxDiskCopyProgress;
        });
    }
}

