/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ClassDiscriminator;
import com.azure.resourcemanager.databox.models.ContactDetails;
import com.azure.resourcemanager.databox.models.CopyLogDetails;
import com.azure.resourcemanager.databox.models.CustomerResolutionCode;
import com.azure.resourcemanager.databox.models.DataBoxCustomerDiskCopyProgress;
import com.azure.resourcemanager.databox.models.DataCenterCode;
import com.azure.resourcemanager.databox.models.DataExportDetails;
import com.azure.resourcemanager.databox.models.DataImportDetails;
import com.azure.resourcemanager.databox.models.DatacenterAddressResponse;
import com.azure.resourcemanager.databox.models.DeviceErasureDetails;
import com.azure.resourcemanager.databox.models.ExportDiskDetails;
import com.azure.resourcemanager.databox.models.ImportDiskDetails;
import com.azure.resourcemanager.databox.models.JobDetails;
import com.azure.resourcemanager.databox.models.JobStages;
import com.azure.resourcemanager.databox.models.KeyEncryptionKey;
import com.azure.resourcemanager.databox.models.LastMitigationActionOnJob;
import com.azure.resourcemanager.databox.models.PackageCarrierDetails;
import com.azure.resourcemanager.databox.models.PackageCarrierInfo;
import com.azure.resourcemanager.databox.models.PackageShippingDetails;
import com.azure.resourcemanager.databox.models.Preferences;
import com.azure.resourcemanager.databox.models.ReverseShippingDetails;
import com.azure.resourcemanager.databox.models.ShippingAddress;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DataBoxCustomerDiskJobDetails
extends JobDetails {
    private ClassDiscriminator jobDetailsType = ClassDiscriminator.DATA_BOX_CUSTOMER_DISK;
    private Map<String, ImportDiskDetails> importDiskDetailsCollection;
    private Map<String, ExportDiskDetails> exportDiskDetailsCollection;
    private List<DataBoxCustomerDiskCopyProgress> copyProgress;
    private PackageCarrierInfo deliverToDcPackageDetails;
    private PackageCarrierDetails returnToCustomerPackageDetails;
    private Boolean enableManifestBackup;
    private static final ClientLogger LOGGER = new ClientLogger(DataBoxCustomerDiskJobDetails.class);

    @Override
    public ClassDiscriminator jobDetailsType() {
        return this.jobDetailsType;
    }

    public Map<String, ImportDiskDetails> importDiskDetailsCollection() {
        return this.importDiskDetailsCollection;
    }

    public DataBoxCustomerDiskJobDetails withImportDiskDetailsCollection(Map<String, ImportDiskDetails> importDiskDetailsCollection) {
        this.importDiskDetailsCollection = importDiskDetailsCollection;
        return this;
    }

    public Map<String, ExportDiskDetails> exportDiskDetailsCollection() {
        return this.exportDiskDetailsCollection;
    }

    public List<DataBoxCustomerDiskCopyProgress> copyProgress() {
        return this.copyProgress;
    }

    public PackageCarrierInfo deliverToDcPackageDetails() {
        return this.deliverToDcPackageDetails;
    }

    public PackageCarrierDetails returnToCustomerPackageDetails() {
        return this.returnToCustomerPackageDetails;
    }

    public DataBoxCustomerDiskJobDetails withReturnToCustomerPackageDetails(PackageCarrierDetails returnToCustomerPackageDetails) {
        this.returnToCustomerPackageDetails = returnToCustomerPackageDetails;
        return this;
    }

    public Boolean enableManifestBackup() {
        return this.enableManifestBackup;
    }

    public DataBoxCustomerDiskJobDetails withEnableManifestBackup(Boolean enableManifestBackup) {
        this.enableManifestBackup = enableManifestBackup;
        return this;
    }

    @Override
    public DataBoxCustomerDiskJobDetails withContactDetails(ContactDetails contactDetails) {
        super.withContactDetails(contactDetails);
        return this;
    }

    @Override
    public DataBoxCustomerDiskJobDetails withShippingAddress(ShippingAddress shippingAddress) {
        super.withShippingAddress(shippingAddress);
        return this;
    }

    @Override
    public DataBoxCustomerDiskJobDetails withDataImportDetails(List<DataImportDetails> dataImportDetails) {
        super.withDataImportDetails(dataImportDetails);
        return this;
    }

    @Override
    public DataBoxCustomerDiskJobDetails withDataExportDetails(List<DataExportDetails> dataExportDetails) {
        super.withDataExportDetails(dataExportDetails);
        return this;
    }

    @Override
    public DataBoxCustomerDiskJobDetails withPreferences(Preferences preferences) {
        super.withPreferences(preferences);
        return this;
    }

    @Override
    public DataBoxCustomerDiskJobDetails withReverseShippingDetails(ReverseShippingDetails reverseShippingDetails) {
        super.withReverseShippingDetails(reverseShippingDetails);
        return this;
    }

    @Override
    public DataBoxCustomerDiskJobDetails withKeyEncryptionKey(KeyEncryptionKey keyEncryptionKey) {
        super.withKeyEncryptionKey(keyEncryptionKey);
        return this;
    }

    @Override
    public DataBoxCustomerDiskJobDetails withExpectedDataSizeInTeraBytes(Integer expectedDataSizeInTeraBytes) {
        super.withExpectedDataSizeInTeraBytes(expectedDataSizeInTeraBytes);
        return this;
    }

    @Override
    public void validate() {
        if (this.importDiskDetailsCollection() != null) {
            this.importDiskDetailsCollection().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.exportDiskDetailsCollection() != null) {
            this.exportDiskDetailsCollection().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.copyProgress() != null) {
            this.copyProgress().forEach(e -> e.validate());
        }
        if (this.deliverToDcPackageDetails() != null) {
            this.deliverToDcPackageDetails().validate();
        }
        if (this.returnToCustomerPackageDetails() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property returnToCustomerPackageDetails in model DataBoxCustomerDiskJobDetails"));
        }
        this.returnToCustomerPackageDetails().validate();
        if (this.jobStages() != null) {
            this.jobStages().forEach(e -> e.validate());
        }
        if (this.contactDetails() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property contactDetails in model DataBoxCustomerDiskJobDetails"));
        }
        this.contactDetails().validate();
        if (this.shippingAddress() != null) {
            this.shippingAddress().validate();
        }
        if (this.deliveryPackage() != null) {
            this.deliveryPackage().validate();
        }
        if (this.returnPackage() != null) {
            this.returnPackage().validate();
        }
        if (this.dataImportDetails() != null) {
            this.dataImportDetails().forEach(e -> e.validate());
        }
        if (this.dataExportDetails() != null) {
            this.dataExportDetails().forEach(e -> e.validate());
        }
        if (this.preferences() != null) {
            this.preferences().validate();
        }
        if (this.reverseShippingDetails() != null) {
            this.reverseShippingDetails().validate();
        }
        if (this.copyLogDetails() != null) {
            this.copyLogDetails().forEach(e -> e.validate());
        }
        if (this.deviceErasureDetails() != null) {
            this.deviceErasureDetails().validate();
        }
        if (this.keyEncryptionKey() != null) {
            this.keyEncryptionKey().validate();
        }
        if (this.lastMitigationActionOnJob() != null) {
            this.lastMitigationActionOnJob().validate();
        }
        if (this.datacenterAddress() != null) {
            this.datacenterAddress().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("contactDetails", (JsonSerializable)this.contactDetails());
        jsonWriter.writeJsonField("shippingAddress", (JsonSerializable)this.shippingAddress());
        jsonWriter.writeArrayField("dataImportDetails", this.dataImportDetails(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("dataExportDetails", this.dataExportDetails(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("preferences", (JsonSerializable)this.preferences());
        jsonWriter.writeJsonField("reverseShippingDetails", (JsonSerializable)this.reverseShippingDetails());
        jsonWriter.writeJsonField("keyEncryptionKey", (JsonSerializable)this.keyEncryptionKey());
        jsonWriter.writeNumberField("expectedDataSizeInTeraBytes", (Number)this.expectedDataSizeInTeraBytes());
        jsonWriter.writeJsonField("returnToCustomerPackageDetails", (JsonSerializable)this.returnToCustomerPackageDetails);
        jsonWriter.writeStringField("jobDetailsType", this.jobDetailsType == null ? null : this.jobDetailsType.toString());
        jsonWriter.writeMapField("importDiskDetailsCollection", this.importDiskDetailsCollection, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("enableManifestBackup", this.enableManifestBackup);
        return jsonWriter.writeEndObject();
    }

    public static DataBoxCustomerDiskJobDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DataBoxCustomerDiskJobDetails)jsonReader.readObject(reader -> {
            DataBoxCustomerDiskJobDetails deserializedDataBoxCustomerDiskJobDetails = new DataBoxCustomerDiskJobDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contactDetails".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskJobDetails.withContactDetails(ContactDetails.fromJson(reader));
                    continue;
                }
                if ("jobStages".equals(fieldName)) {
                    List jobStages = reader.readArray(reader1 -> JobStages.fromJson(reader1));
                    deserializedDataBoxCustomerDiskJobDetails.withJobStages(jobStages);
                    continue;
                }
                if ("shippingAddress".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskJobDetails.withShippingAddress(ShippingAddress.fromJson(reader));
                    continue;
                }
                if ("deliveryPackage".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskJobDetails.withDeliveryPackage(PackageShippingDetails.fromJson(reader));
                    continue;
                }
                if ("returnPackage".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskJobDetails.withReturnPackage(PackageShippingDetails.fromJson(reader));
                    continue;
                }
                if ("dataImportDetails".equals(fieldName)) {
                    List dataImportDetails = reader.readArray(reader1 -> DataImportDetails.fromJson(reader1));
                    deserializedDataBoxCustomerDiskJobDetails.withDataImportDetails(dataImportDetails);
                    continue;
                }
                if ("dataExportDetails".equals(fieldName)) {
                    List dataExportDetails = reader.readArray(reader1 -> DataExportDetails.fromJson(reader1));
                    deserializedDataBoxCustomerDiskJobDetails.withDataExportDetails(dataExportDetails);
                    continue;
                }
                if ("preferences".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskJobDetails.withPreferences(Preferences.fromJson(reader));
                    continue;
                }
                if ("reverseShippingDetails".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskJobDetails.withReverseShippingDetails(ReverseShippingDetails.fromJson(reader));
                    continue;
                }
                if ("copyLogDetails".equals(fieldName)) {
                    List copyLogDetails = reader.readArray(reader1 -> CopyLogDetails.fromJson(reader1));
                    deserializedDataBoxCustomerDiskJobDetails.withCopyLogDetails(copyLogDetails);
                    continue;
                }
                if ("reverseShipmentLabelSasKey".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskJobDetails.withReverseShipmentLabelSasKey(reader.getString());
                    continue;
                }
                if ("chainOfCustodySasKey".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskJobDetails.withChainOfCustodySasKey(reader.getString());
                    continue;
                }
                if ("deviceErasureDetails".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskJobDetails.withDeviceErasureDetails(DeviceErasureDetails.fromJson(reader));
                    continue;
                }
                if ("keyEncryptionKey".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskJobDetails.withKeyEncryptionKey(KeyEncryptionKey.fromJson(reader));
                    continue;
                }
                if ("expectedDataSizeInTeraBytes".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskJobDetails.withExpectedDataSizeInTeraBytes((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List actions = reader.readArray(reader1 -> CustomerResolutionCode.fromString(reader1.getString()));
                    deserializedDataBoxCustomerDiskJobDetails.withActions(actions);
                    continue;
                }
                if ("lastMitigationActionOnJob".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskJobDetails.withLastMitigationActionOnJob(LastMitigationActionOnJob.fromJson(reader));
                    continue;
                }
                if ("datacenterAddress".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskJobDetails.withDatacenterAddress(DatacenterAddressResponse.fromJson(reader));
                    continue;
                }
                if ("dataCenterCode".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskJobDetails.withDataCenterCode(DataCenterCode.fromString(reader.getString()));
                    continue;
                }
                if ("returnToCustomerPackageDetails".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskJobDetails.returnToCustomerPackageDetails = PackageCarrierDetails.fromJson(reader);
                    continue;
                }
                if ("jobDetailsType".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskJobDetails.jobDetailsType = ClassDiscriminator.fromString(reader.getString());
                    continue;
                }
                if ("importDiskDetailsCollection".equals(fieldName)) {
                    Map importDiskDetailsCollection;
                    deserializedDataBoxCustomerDiskJobDetails.importDiskDetailsCollection = importDiskDetailsCollection = reader.readMap(reader1 -> ImportDiskDetails.fromJson(reader1));
                    continue;
                }
                if ("exportDiskDetailsCollection".equals(fieldName)) {
                    Map exportDiskDetailsCollection;
                    deserializedDataBoxCustomerDiskJobDetails.exportDiskDetailsCollection = exportDiskDetailsCollection = reader.readMap(reader1 -> ExportDiskDetails.fromJson(reader1));
                    continue;
                }
                if ("copyProgress".equals(fieldName)) {
                    List copyProgress;
                    deserializedDataBoxCustomerDiskJobDetails.copyProgress = copyProgress = reader.readArray(reader1 -> DataBoxCustomerDiskCopyProgress.fromJson(reader1));
                    continue;
                }
                if ("deliverToDcPackageDetails".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskJobDetails.deliverToDcPackageDetails = PackageCarrierInfo.fromJson(reader);
                    continue;
                }
                if ("enableManifestBackup".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskJobDetails.enableManifestBackup = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataBoxCustomerDiskJobDetails;
        });
    }
}

