/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.CloudError;
import com.azure.resourcemanager.databox.models.CopyProgress;
import com.azure.resourcemanager.databox.models.CopyStatus;
import com.azure.resourcemanager.databox.models.CustomerResolutionCode;
import com.azure.resourcemanager.databox.models.DataAccountType;
import com.azure.resourcemanager.databox.models.TransferType;
import java.io.IOException;
import java.util.List;

public final class DataBoxCustomerDiskCopyProgress
extends CopyProgress {
    private String serialNumber;
    private CopyStatus copyStatus;
    private List<CustomerResolutionCode> actions;
    private CloudError error;
    private Boolean isEnumerationInProgress;
    private Long invalidDirectoriesProcessed;
    private Long directoriesErroredOut;
    private Long filesErroredOut;
    private Long renamedContainerCount;
    private Long invalidFileBytesUploaded;
    private Long invalidFilesProcessed;
    private Long totalFilesToProcess;
    private Long filesProcessed;
    private Long totalBytesToProcess;
    private Long bytesProcessed;
    private String accountId;
    private DataAccountType dataAccountType;
    private TransferType transferType;
    private String storageAccountName;

    public String serialNumber() {
        return this.serialNumber;
    }

    public CopyStatus copyStatus() {
        return this.copyStatus;
    }

    @Override
    public List<CustomerResolutionCode> actions() {
        return this.actions;
    }

    @Override
    public CloudError error() {
        return this.error;
    }

    @Override
    public Boolean isEnumerationInProgress() {
        return this.isEnumerationInProgress;
    }

    @Override
    public Long invalidDirectoriesProcessed() {
        return this.invalidDirectoriesProcessed;
    }

    @Override
    public Long directoriesErroredOut() {
        return this.directoriesErroredOut;
    }

    @Override
    public Long filesErroredOut() {
        return this.filesErroredOut;
    }

    @Override
    public Long renamedContainerCount() {
        return this.renamedContainerCount;
    }

    @Override
    public Long invalidFileBytesUploaded() {
        return this.invalidFileBytesUploaded;
    }

    @Override
    public Long invalidFilesProcessed() {
        return this.invalidFilesProcessed;
    }

    @Override
    public Long totalFilesToProcess() {
        return this.totalFilesToProcess;
    }

    @Override
    public Long filesProcessed() {
        return this.filesProcessed;
    }

    @Override
    public Long totalBytesToProcess() {
        return this.totalBytesToProcess;
    }

    @Override
    public Long bytesProcessed() {
        return this.bytesProcessed;
    }

    @Override
    public String accountId() {
        return this.accountId;
    }

    @Override
    public DataAccountType dataAccountType() {
        return this.dataAccountType;
    }

    @Override
    public TransferType transferType() {
        return this.transferType;
    }

    @Override
    public String storageAccountName() {
        return this.storageAccountName;
    }

    @Override
    public void validate() {
        if (this.error() != null) {
            this.error().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static DataBoxCustomerDiskCopyProgress fromJson(JsonReader jsonReader) throws IOException {
        return (DataBoxCustomerDiskCopyProgress)jsonReader.readObject(reader -> {
            DataBoxCustomerDiskCopyProgress deserializedDataBoxCustomerDiskCopyProgress = new DataBoxCustomerDiskCopyProgress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageAccountName".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskCopyProgress.storageAccountName = reader.getString();
                    continue;
                }
                if ("transferType".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskCopyProgress.transferType = TransferType.fromString(reader.getString());
                    continue;
                }
                if ("dataAccountType".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskCopyProgress.dataAccountType = DataAccountType.fromString(reader.getString());
                    continue;
                }
                if ("accountId".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskCopyProgress.accountId = reader.getString();
                    continue;
                }
                if ("bytesProcessed".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskCopyProgress.bytesProcessed = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("totalBytesToProcess".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskCopyProgress.totalBytesToProcess = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("filesProcessed".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskCopyProgress.filesProcessed = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("totalFilesToProcess".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskCopyProgress.totalFilesToProcess = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("invalidFilesProcessed".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskCopyProgress.invalidFilesProcessed = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("invalidFileBytesUploaded".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskCopyProgress.invalidFileBytesUploaded = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("renamedContainerCount".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskCopyProgress.renamedContainerCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("filesErroredOut".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskCopyProgress.filesErroredOut = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("directoriesErroredOut".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskCopyProgress.directoriesErroredOut = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("invalidDirectoriesProcessed".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskCopyProgress.invalidDirectoriesProcessed = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("isEnumerationInProgress".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskCopyProgress.isEnumerationInProgress = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskCopyProgress.error = CloudError.fromJson(reader);
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List actions;
                    deserializedDataBoxCustomerDiskCopyProgress.actions = actions = reader.readArray(reader1 -> CustomerResolutionCode.fromString(reader1.getString()));
                    continue;
                }
                if ("serialNumber".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskCopyProgress.serialNumber = reader.getString();
                    continue;
                }
                if ("copyStatus".equals(fieldName)) {
                    deserializedDataBoxCustomerDiskCopyProgress.copyStatus = CopyStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataBoxCustomerDiskCopyProgress;
        });
    }
}

