/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.DataAccountType;
import com.azure.resourcemanager.databox.models.ManagedDiskDetails;
import com.azure.resourcemanager.databox.models.StorageAccountDetails;
import java.io.IOException;

public class DataAccountDetails
implements JsonSerializable<DataAccountDetails> {
    private DataAccountType dataAccountType;
    private String sharePassword;

    public DataAccountType dataAccountType() {
        return this.dataAccountType;
    }

    public String sharePassword() {
        return this.sharePassword;
    }

    public DataAccountDetails withSharePassword(String sharePassword) {
        this.sharePassword = sharePassword;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dataAccountType", this.dataAccountType == null ? null : this.dataAccountType.toString());
        jsonWriter.writeStringField("sharePassword", this.sharePassword);
        return jsonWriter.writeEndObject();
    }

    public static DataAccountDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DataAccountDetails)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                DataAccountDetails dataAccountDetails;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("dataAccountType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("ManagedDisk".equals(discriminatorValue)) {
                    dataAccountDetails = ManagedDiskDetails.fromJson(readerToUse.reset());
                    return dataAccountDetails;
                }
                if ("StorageAccount".equals(discriminatorValue)) {
                    dataAccountDetails = StorageAccountDetails.fromJson(readerToUse.reset());
                    return dataAccountDetails;
                }
                dataAccountDetails = DataAccountDetails.fromJsonKnownDiscriminator(readerToUse.reset());
                return dataAccountDetails;
            }
        });
    }

    static DataAccountDetails fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (DataAccountDetails)jsonReader.readObject(reader -> {
            DataAccountDetails deserializedDataAccountDetails = new DataAccountDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataAccountType".equals(fieldName)) {
                    deserializedDataAccountDetails.dataAccountType = DataAccountType.fromString(reader.getString());
                    continue;
                }
                if ("sharePassword".equals(fieldName)) {
                    deserializedDataAccountDetails.sharePassword = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataAccountDetails;
        });
    }
}

