/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ClassDiscriminator;
import com.azure.resourcemanager.databox.models.CloudError;
import com.azure.resourcemanager.databox.models.DcAccessSecurityCode;
import com.azure.resourcemanager.databox.models.DiskSecret;
import com.azure.resourcemanager.databox.models.JobSecrets;
import java.io.IOException;
import java.util.List;

public final class CustomerDiskJobSecrets
extends JobSecrets {
    private ClassDiscriminator jobSecretsType = ClassDiscriminator.DATA_BOX_CUSTOMER_DISK;
    private List<DiskSecret> diskSecrets;
    private String carrierAccountNumber;

    @Override
    public ClassDiscriminator jobSecretsType() {
        return this.jobSecretsType;
    }

    public List<DiskSecret> diskSecrets() {
        return this.diskSecrets;
    }

    public String carrierAccountNumber() {
        return this.carrierAccountNumber;
    }

    @Override
    public void validate() {
        if (this.diskSecrets() != null) {
            this.diskSecrets().forEach(e -> e.validate());
        }
        if (this.dcAccessSecurityCode() != null) {
            this.dcAccessSecurityCode().validate();
        }
        if (this.error() != null) {
            this.error().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("jobSecretsType", this.jobSecretsType == null ? null : this.jobSecretsType.toString());
        return jsonWriter.writeEndObject();
    }

    public static CustomerDiskJobSecrets fromJson(JsonReader jsonReader) throws IOException {
        return (CustomerDiskJobSecrets)jsonReader.readObject(reader -> {
            CustomerDiskJobSecrets deserializedCustomerDiskJobSecrets = new CustomerDiskJobSecrets();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dcAccessSecurityCode".equals(fieldName)) {
                    deserializedCustomerDiskJobSecrets.withDcAccessSecurityCode(DcAccessSecurityCode.fromJson(reader));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedCustomerDiskJobSecrets.withError(CloudError.fromJson(reader));
                    continue;
                }
                if ("jobSecretsType".equals(fieldName)) {
                    deserializedCustomerDiskJobSecrets.jobSecretsType = ClassDiscriminator.fromString(reader.getString());
                    continue;
                }
                if ("diskSecrets".equals(fieldName)) {
                    List diskSecrets;
                    deserializedCustomerDiskJobSecrets.diskSecrets = diskSecrets = reader.readArray(reader1 -> DiskSecret.fromJson(reader1));
                    continue;
                }
                if ("carrierAccountNumber".equals(fieldName)) {
                    deserializedCustomerDiskJobSecrets.carrierAccountNumber = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomerDiskJobSecrets;
        });
    }
}

