/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ModelName;
import com.azure.resourcemanager.databox.models.SkuName;
import com.azure.resourcemanager.databox.models.ValidationInputDiscriminator;
import com.azure.resourcemanager.databox.models.ValidationInputRequest;
import java.io.IOException;

public final class CreateOrderLimitForSubscriptionValidationRequest
extends ValidationInputRequest {
    private ValidationInputDiscriminator validationType = ValidationInputDiscriminator.VALIDATE_CREATE_ORDER_LIMIT;
    private SkuName deviceType;
    private ModelName model;
    private static final ClientLogger LOGGER = new ClientLogger(CreateOrderLimitForSubscriptionValidationRequest.class);

    @Override
    public ValidationInputDiscriminator validationType() {
        return this.validationType;
    }

    public SkuName deviceType() {
        return this.deviceType;
    }

    public CreateOrderLimitForSubscriptionValidationRequest withDeviceType(SkuName deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public ModelName model() {
        return this.model;
    }

    public CreateOrderLimitForSubscriptionValidationRequest withModel(ModelName model) {
        this.model = model;
        return this;
    }

    @Override
    public void validate() {
        if (this.deviceType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property deviceType in model CreateOrderLimitForSubscriptionValidationRequest"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("deviceType", this.deviceType == null ? null : this.deviceType.toString());
        jsonWriter.writeStringField("validationType", this.validationType == null ? null : this.validationType.toString());
        jsonWriter.writeStringField("model", this.model == null ? null : this.model.toString());
        return jsonWriter.writeEndObject();
    }

    public static CreateOrderLimitForSubscriptionValidationRequest fromJson(JsonReader jsonReader) throws IOException {
        return (CreateOrderLimitForSubscriptionValidationRequest)jsonReader.readObject(reader -> {
            CreateOrderLimitForSubscriptionValidationRequest deserializedCreateOrderLimitForSubscriptionValidationRequest = new CreateOrderLimitForSubscriptionValidationRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deviceType".equals(fieldName)) {
                    deserializedCreateOrderLimitForSubscriptionValidationRequest.deviceType = SkuName.fromString(reader.getString());
                    continue;
                }
                if ("validationType".equals(fieldName)) {
                    deserializedCreateOrderLimitForSubscriptionValidationRequest.validationType = ValidationInputDiscriminator.fromString(reader.getString());
                    continue;
                }
                if ("model".equals(fieldName)) {
                    deserializedCreateOrderLimitForSubscriptionValidationRequest.model = ModelName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCreateOrderLimitForSubscriptionValidationRequest;
        });
    }
}

