/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ValidationInputRequest;
import com.azure.resourcemanager.databox.models.ValidationRequest;
import java.io.IOException;
import java.util.List;

public final class CreateJobValidations
extends ValidationRequest {
    private String validationCategory = "JobCreationValidation";
    private static final ClientLogger LOGGER = new ClientLogger(CreateJobValidations.class);

    @Override
    public String validationCategory() {
        return this.validationCategory;
    }

    @Override
    public CreateJobValidations withIndividualRequestDetails(List<ValidationInputRequest> individualRequestDetails) {
        super.withIndividualRequestDetails(individualRequestDetails);
        return this;
    }

    @Override
    public void validate() {
        if (this.individualRequestDetails() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property individualRequestDetails in model CreateJobValidations"));
        }
        this.individualRequestDetails().forEach(e -> e.validate());
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("individualRequestDetails", this.individualRequestDetails(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("validationCategory", this.validationCategory);
        return jsonWriter.writeEndObject();
    }

    public static CreateJobValidations fromJson(JsonReader jsonReader) throws IOException {
        return (CreateJobValidations)jsonReader.readObject(reader -> {
            CreateJobValidations deserializedCreateJobValidations = new CreateJobValidations();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("individualRequestDetails".equals(fieldName)) {
                    List individualRequestDetails = reader.readArray(reader1 -> ValidationInputRequest.fromJson(reader1));
                    deserializedCreateJobValidations.withIndividualRequestDetails(individualRequestDetails);
                    continue;
                }
                if ("validationCategory".equals(fieldName)) {
                    deserializedCreateJobValidations.validationCategory = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCreateJobValidations;
        });
    }
}

