/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.CloudError;
import com.azure.resourcemanager.databox.models.CustomerResolutionCode;
import com.azure.resourcemanager.databox.models.DataAccountType;
import com.azure.resourcemanager.databox.models.TransferType;
import java.io.IOException;
import java.util.List;

public class CopyProgress
implements JsonSerializable<CopyProgress> {
    private String storageAccountName;
    private TransferType transferType;
    private DataAccountType dataAccountType;
    private String accountId;
    private Long bytesProcessed;
    private Long totalBytesToProcess;
    private Long filesProcessed;
    private Long totalFilesToProcess;
    private Long invalidFilesProcessed;
    private Long invalidFileBytesUploaded;
    private Long renamedContainerCount;
    private Long filesErroredOut;
    private Long directoriesErroredOut;
    private Long invalidDirectoriesProcessed;
    private Boolean isEnumerationInProgress;
    private CloudError error;
    private List<CustomerResolutionCode> actions;

    public String storageAccountName() {
        return this.storageAccountName;
    }

    CopyProgress withStorageAccountName(String storageAccountName) {
        this.storageAccountName = storageAccountName;
        return this;
    }

    public TransferType transferType() {
        return this.transferType;
    }

    CopyProgress withTransferType(TransferType transferType) {
        this.transferType = transferType;
        return this;
    }

    public DataAccountType dataAccountType() {
        return this.dataAccountType;
    }

    CopyProgress withDataAccountType(DataAccountType dataAccountType) {
        this.dataAccountType = dataAccountType;
        return this;
    }

    public String accountId() {
        return this.accountId;
    }

    CopyProgress withAccountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    public Long bytesProcessed() {
        return this.bytesProcessed;
    }

    CopyProgress withBytesProcessed(Long bytesProcessed) {
        this.bytesProcessed = bytesProcessed;
        return this;
    }

    public Long totalBytesToProcess() {
        return this.totalBytesToProcess;
    }

    CopyProgress withTotalBytesToProcess(Long totalBytesToProcess) {
        this.totalBytesToProcess = totalBytesToProcess;
        return this;
    }

    public Long filesProcessed() {
        return this.filesProcessed;
    }

    CopyProgress withFilesProcessed(Long filesProcessed) {
        this.filesProcessed = filesProcessed;
        return this;
    }

    public Long totalFilesToProcess() {
        return this.totalFilesToProcess;
    }

    CopyProgress withTotalFilesToProcess(Long totalFilesToProcess) {
        this.totalFilesToProcess = totalFilesToProcess;
        return this;
    }

    public Long invalidFilesProcessed() {
        return this.invalidFilesProcessed;
    }

    CopyProgress withInvalidFilesProcessed(Long invalidFilesProcessed) {
        this.invalidFilesProcessed = invalidFilesProcessed;
        return this;
    }

    public Long invalidFileBytesUploaded() {
        return this.invalidFileBytesUploaded;
    }

    CopyProgress withInvalidFileBytesUploaded(Long invalidFileBytesUploaded) {
        this.invalidFileBytesUploaded = invalidFileBytesUploaded;
        return this;
    }

    public Long renamedContainerCount() {
        return this.renamedContainerCount;
    }

    CopyProgress withRenamedContainerCount(Long renamedContainerCount) {
        this.renamedContainerCount = renamedContainerCount;
        return this;
    }

    public Long filesErroredOut() {
        return this.filesErroredOut;
    }

    CopyProgress withFilesErroredOut(Long filesErroredOut) {
        this.filesErroredOut = filesErroredOut;
        return this;
    }

    public Long directoriesErroredOut() {
        return this.directoriesErroredOut;
    }

    CopyProgress withDirectoriesErroredOut(Long directoriesErroredOut) {
        this.directoriesErroredOut = directoriesErroredOut;
        return this;
    }

    public Long invalidDirectoriesProcessed() {
        return this.invalidDirectoriesProcessed;
    }

    CopyProgress withInvalidDirectoriesProcessed(Long invalidDirectoriesProcessed) {
        this.invalidDirectoriesProcessed = invalidDirectoriesProcessed;
        return this;
    }

    public Boolean isEnumerationInProgress() {
        return this.isEnumerationInProgress;
    }

    CopyProgress withIsEnumerationInProgress(Boolean isEnumerationInProgress) {
        this.isEnumerationInProgress = isEnumerationInProgress;
        return this;
    }

    public CloudError error() {
        return this.error;
    }

    CopyProgress withError(CloudError error) {
        this.error = error;
        return this;
    }

    public List<CustomerResolutionCode> actions() {
        return this.actions;
    }

    CopyProgress withActions(List<CustomerResolutionCode> actions) {
        this.actions = actions;
        return this;
    }

    public void validate() {
        if (this.error() != null) {
            this.error().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static CopyProgress fromJson(JsonReader jsonReader) throws IOException {
        return (CopyProgress)jsonReader.readObject(reader -> {
            CopyProgress deserializedCopyProgress = new CopyProgress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageAccountName".equals(fieldName)) {
                    deserializedCopyProgress.storageAccountName = reader.getString();
                    continue;
                }
                if ("transferType".equals(fieldName)) {
                    deserializedCopyProgress.transferType = TransferType.fromString(reader.getString());
                    continue;
                }
                if ("dataAccountType".equals(fieldName)) {
                    deserializedCopyProgress.dataAccountType = DataAccountType.fromString(reader.getString());
                    continue;
                }
                if ("accountId".equals(fieldName)) {
                    deserializedCopyProgress.accountId = reader.getString();
                    continue;
                }
                if ("bytesProcessed".equals(fieldName)) {
                    deserializedCopyProgress.bytesProcessed = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("totalBytesToProcess".equals(fieldName)) {
                    deserializedCopyProgress.totalBytesToProcess = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("filesProcessed".equals(fieldName)) {
                    deserializedCopyProgress.filesProcessed = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("totalFilesToProcess".equals(fieldName)) {
                    deserializedCopyProgress.totalFilesToProcess = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("invalidFilesProcessed".equals(fieldName)) {
                    deserializedCopyProgress.invalidFilesProcessed = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("invalidFileBytesUploaded".equals(fieldName)) {
                    deserializedCopyProgress.invalidFileBytesUploaded = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("renamedContainerCount".equals(fieldName)) {
                    deserializedCopyProgress.renamedContainerCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("filesErroredOut".equals(fieldName)) {
                    deserializedCopyProgress.filesErroredOut = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("directoriesErroredOut".equals(fieldName)) {
                    deserializedCopyProgress.directoriesErroredOut = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("invalidDirectoriesProcessed".equals(fieldName)) {
                    deserializedCopyProgress.invalidDirectoriesProcessed = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("isEnumerationInProgress".equals(fieldName)) {
                    deserializedCopyProgress.isEnumerationInProgress = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedCopyProgress.error = CloudError.fromJson(reader);
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List actions;
                    deserializedCopyProgress.actions = actions = reader.readArray(reader1 -> CustomerResolutionCode.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCopyProgress;
        });
    }
}

