/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ContactInfo
implements JsonSerializable<ContactInfo> {
    private String contactName;
    private String phone;
    private String phoneExtension;
    private String mobile;
    private static final ClientLogger LOGGER = new ClientLogger(ContactInfo.class);

    public String contactName() {
        return this.contactName;
    }

    public ContactInfo withContactName(String contactName) {
        this.contactName = contactName;
        return this;
    }

    public String phone() {
        return this.phone;
    }

    public ContactInfo withPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public String phoneExtension() {
        return this.phoneExtension;
    }

    public ContactInfo withPhoneExtension(String phoneExtension) {
        this.phoneExtension = phoneExtension;
        return this;
    }

    public String mobile() {
        return this.mobile;
    }

    public ContactInfo withMobile(String mobile) {
        this.mobile = mobile;
        return this;
    }

    public void validate() {
        if (this.contactName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property contactName in model ContactInfo"));
        }
        if (this.phone() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property phone in model ContactInfo"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contactName", this.contactName);
        jsonWriter.writeStringField("phone", this.phone);
        jsonWriter.writeStringField("phoneExtension", this.phoneExtension);
        jsonWriter.writeStringField("mobile", this.mobile);
        return jsonWriter.writeEndObject();
    }

    public static ContactInfo fromJson(JsonReader jsonReader) throws IOException {
        return (ContactInfo)jsonReader.readObject(reader -> {
            ContactInfo deserializedContactInfo = new ContactInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contactName".equals(fieldName)) {
                    deserializedContactInfo.contactName = reader.getString();
                    continue;
                }
                if ("phone".equals(fieldName)) {
                    deserializedContactInfo.phone = reader.getString();
                    continue;
                }
                if ("phoneExtension".equals(fieldName)) {
                    deserializedContactInfo.phoneExtension = reader.getString();
                    continue;
                }
                if ("mobile".equals(fieldName)) {
                    deserializedContactInfo.mobile = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContactInfo;
        });
    }
}

