/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.NotificationPreference;
import java.io.IOException;
import java.util.List;

public final class ContactDetails
implements JsonSerializable<ContactDetails> {
    private String contactName;
    private String phone;
    private String phoneExtension;
    private String mobile;
    private List<String> emailList;
    private List<NotificationPreference> notificationPreference;
    private static final ClientLogger LOGGER = new ClientLogger(ContactDetails.class);

    public String contactName() {
        return this.contactName;
    }

    public ContactDetails withContactName(String contactName) {
        this.contactName = contactName;
        return this;
    }

    public String phone() {
        return this.phone;
    }

    public ContactDetails withPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public String phoneExtension() {
        return this.phoneExtension;
    }

    public ContactDetails withPhoneExtension(String phoneExtension) {
        this.phoneExtension = phoneExtension;
        return this;
    }

    public String mobile() {
        return this.mobile;
    }

    public ContactDetails withMobile(String mobile) {
        this.mobile = mobile;
        return this;
    }

    public List<String> emailList() {
        return this.emailList;
    }

    public ContactDetails withEmailList(List<String> emailList) {
        this.emailList = emailList;
        return this;
    }

    public List<NotificationPreference> notificationPreference() {
        return this.notificationPreference;
    }

    public ContactDetails withNotificationPreference(List<NotificationPreference> notificationPreference) {
        this.notificationPreference = notificationPreference;
        return this;
    }

    public void validate() {
        if (this.contactName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property contactName in model ContactDetails"));
        }
        if (this.phone() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property phone in model ContactDetails"));
        }
        if (this.emailList() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property emailList in model ContactDetails"));
        }
        if (this.notificationPreference() != null) {
            this.notificationPreference().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contactName", this.contactName);
        jsonWriter.writeStringField("phone", this.phone);
        jsonWriter.writeArrayField("emailList", this.emailList, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("phoneExtension", this.phoneExtension);
        jsonWriter.writeStringField("mobile", this.mobile);
        jsonWriter.writeArrayField("notificationPreference", this.notificationPreference, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ContactDetails fromJson(JsonReader jsonReader) throws IOException {
        return (ContactDetails)jsonReader.readObject(reader -> {
            ContactDetails deserializedContactDetails = new ContactDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contactName".equals(fieldName)) {
                    deserializedContactDetails.contactName = reader.getString();
                    continue;
                }
                if ("phone".equals(fieldName)) {
                    deserializedContactDetails.phone = reader.getString();
                    continue;
                }
                if ("emailList".equals(fieldName)) {
                    List emailList;
                    deserializedContactDetails.emailList = emailList = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("phoneExtension".equals(fieldName)) {
                    deserializedContactDetails.phoneExtension = reader.getString();
                    continue;
                }
                if ("mobile".equals(fieldName)) {
                    deserializedContactDetails.mobile = reader.getString();
                    continue;
                }
                if ("notificationPreference".equals(fieldName)) {
                    List notificationPreference;
                    deserializedContactDetails.notificationPreference = notificationPreference = reader.readArray(reader1 -> NotificationPreference.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContactDetails;
        });
    }
}

