/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.AdditionalErrorInfo;
import java.io.IOException;
import java.util.List;

public final class CloudError
implements JsonSerializable<CloudError> {
    private List<AdditionalErrorInfo> additionalInfo;
    private String code;
    private List<CloudError> details;
    private String message;
    private String target;

    public List<AdditionalErrorInfo> additionalInfo() {
        return this.additionalInfo;
    }

    public String code() {
        return this.code;
    }

    public CloudError withCode(String code) {
        this.code = code;
        return this;
    }

    public List<CloudError> details() {
        return this.details;
    }

    public String message() {
        return this.message;
    }

    public CloudError withMessage(String message) {
        this.message = message;
        return this;
    }

    public String target() {
        return this.target;
    }

    public CloudError withTarget(String target) {
        this.target = target;
        return this;
    }

    public void validate() {
        if (this.additionalInfo() != null) {
            this.additionalInfo().forEach(e -> e.validate());
        }
        if (this.details() != null) {
            this.details().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("target", this.target);
        return jsonWriter.writeEndObject();
    }

    public static CloudError fromJson(JsonReader jsonReader) throws IOException {
        return (CloudError)jsonReader.readObject(reader -> {
            CloudError deserializedCloudError = new CloudError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("additionalInfo".equals(fieldName)) {
                    List additionalInfo;
                    deserializedCloudError.additionalInfo = additionalInfo = reader.readArray(reader1 -> AdditionalErrorInfo.fromJson(reader1));
                    continue;
                }
                if ("code".equals(fieldName)) {
                    deserializedCloudError.code = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    List details;
                    deserializedCloudError.details = details = reader.readArray(reader1 -> CloudError.fromJson(reader1));
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedCloudError.message = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedCloudError.target = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudError;
        });
    }
}

