/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.SkuName;
import com.azure.resourcemanager.databox.models.TransferType;
import java.io.IOException;
import java.util.List;

public final class AvailableSkuRequest
implements JsonSerializable<AvailableSkuRequest> {
    private TransferType transferType;
    private String country;
    private String location;
    private List<SkuName> skuNames;
    private static final ClientLogger LOGGER = new ClientLogger(AvailableSkuRequest.class);

    public TransferType transferType() {
        return this.transferType;
    }

    public AvailableSkuRequest withTransferType(TransferType transferType) {
        this.transferType = transferType;
        return this;
    }

    public String country() {
        return this.country;
    }

    public AvailableSkuRequest withCountry(String country) {
        this.country = country;
        return this;
    }

    public String location() {
        return this.location;
    }

    public AvailableSkuRequest withLocation(String location) {
        this.location = location;
        return this;
    }

    public List<SkuName> skuNames() {
        return this.skuNames;
    }

    public AvailableSkuRequest withSkuNames(List<SkuName> skuNames) {
        this.skuNames = skuNames;
        return this;
    }

    public void validate() {
        if (this.transferType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property transferType in model AvailableSkuRequest"));
        }
        if (this.country() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property country in model AvailableSkuRequest"));
        }
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model AvailableSkuRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transferType", this.transferType == null ? null : this.transferType.toString());
        jsonWriter.writeStringField("country", this.country);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeArrayField("skuNames", this.skuNames, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static AvailableSkuRequest fromJson(JsonReader jsonReader) throws IOException {
        return (AvailableSkuRequest)jsonReader.readObject(reader -> {
            AvailableSkuRequest deserializedAvailableSkuRequest = new AvailableSkuRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("transferType".equals(fieldName)) {
                    deserializedAvailableSkuRequest.transferType = TransferType.fromString(reader.getString());
                    continue;
                }
                if ("country".equals(fieldName)) {
                    deserializedAvailableSkuRequest.country = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAvailableSkuRequest.location = reader.getString();
                    continue;
                }
                if ("skuNames".equals(fieldName)) {
                    List skuNames;
                    deserializedAvailableSkuRequest.skuNames = skuNames = reader.readArray(reader1 -> SkuName.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAvailableSkuRequest;
        });
    }
}

