/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.AddressValidationStatus;
import com.azure.resourcemanager.databox.models.CloudError;
import com.azure.resourcemanager.databox.models.ShippingAddress;
import com.azure.resourcemanager.databox.models.ValidationInputDiscriminator;
import com.azure.resourcemanager.databox.models.ValidationInputResponse;
import java.io.IOException;
import java.util.List;

public final class AddressValidationProperties
extends ValidationInputResponse {
    private ValidationInputDiscriminator validationType = ValidationInputDiscriminator.VALIDATE_ADDRESS;
    private AddressValidationStatus validationStatus;
    private List<ShippingAddress> alternateAddresses;

    @Override
    public ValidationInputDiscriminator validationType() {
        return this.validationType;
    }

    public AddressValidationStatus validationStatus() {
        return this.validationStatus;
    }

    public List<ShippingAddress> alternateAddresses() {
        return this.alternateAddresses;
    }

    @Override
    public void validate() {
        if (this.alternateAddresses() != null) {
            this.alternateAddresses().forEach(e -> e.validate());
        }
        if (this.error() != null) {
            this.error().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("validationType", this.validationType == null ? null : this.validationType.toString());
        return jsonWriter.writeEndObject();
    }

    public static AddressValidationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AddressValidationProperties)jsonReader.readObject(reader -> {
            AddressValidationProperties deserializedAddressValidationProperties = new AddressValidationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("error".equals(fieldName)) {
                    deserializedAddressValidationProperties.withError(CloudError.fromJson(reader));
                    continue;
                }
                if ("validationType".equals(fieldName)) {
                    deserializedAddressValidationProperties.validationType = ValidationInputDiscriminator.fromString(reader.getString());
                    continue;
                }
                if ("validationStatus".equals(fieldName)) {
                    deserializedAddressValidationProperties.validationStatus = AddressValidationStatus.fromString(reader.getString());
                    continue;
                }
                if ("alternateAddresses".equals(fieldName)) {
                    List alternateAddresses;
                    deserializedAddressValidationProperties.alternateAddresses = alternateAddresses = reader.readArray(reader1 -> ShippingAddress.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAddressValidationProperties;
        });
    }
}

